<div class="panel">
    <div class="panel-heading">Paxy</div>
    <div class="panel-body">
        {if $errorMessage }
            <div class="alert alert-danger">
                Wystąpił błąd. {$errorMessage}
            </div>
        {/if}
        {if $successMessage }
            <div class="alert alert-danger">
                Utworzono paczkę o numerze {$successMessage}
            </div>
        {/if}
        {if $packagesLength == 0}
            <div class="alert alert-info">Brak przesyłek z kurierem, który jest obsługiwany przez paxy.</div>
        {else}
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Nazwa kuriera</th>
                        <th>Łączna waga</th>
                        <th>Numer przesyłki</th>
                        <th>COD</th>
                        <th>Status</th>
                        <th>Punkt odbioru</th>
                        <th>Akcja</th>
                    </tr>
                </thead>
                <tbody>
                    {foreach from=$packages item=package}
                        <tr>
                            <td>{$package.name}</td>
                            <td>
                                {$package.weight|string_format:"%.3f"} {Configuration::get('PS_WEIGHT_UNIT')}
                            </td>
                            <td>
                                {if $package.paxy_parcel_number != null}
                                    {$package.paxy_parcel_number}
                                {else}
                                    <span class="badge badge-primary">Brak</span>
                                {/if}
                            </td>
                            <td>
                                {if $cod === false}
                                    <span class="badge badge-default">Nie</span>
                                {else}
                                    <span class="badge badge-success">{$cod}</span>
                                {/if}
                            </td>
                            <td>
                                {if $package.paxy_parcel_number != null}
                                    <span class="badge badge-primary">{$package.paxyStatus}</span>
                                {/if}
                            </td>
                            <td>
                                {if $pickupPointId}
                                    To zamówienie jest zamówieniem do punktu. <br>
                                    Id punktu: <strong>{$pickupPointId}</strong> <br>
                                {else}
                                    <span class="badge badge-primary">Nie</span>
                                {/if}
                            </td>
                            <td>
                                {if $package.paxy_parcel_number == null}
                                    <form action="{$package.createPackageLink}" method="post">
                                        <div class="form-group">
                                            <label for="">Waga</label>
                                            <input type="text" value="{$package.weight}" name="weight" required min="0.1" step="0.1" class="form-control">
                                        </div>
                                        <div class="form-group">
                                            <label for="">Liczba paczek</label>
                                            <input type="number" name="quantity" required min="1" step="1" value="1" class="form-control">
                                        </div>
                                        <button class="btn btn-success">Stwórz przesyłkę</button>
                                        <input type="hidden" name="id_order_carrier" value="{$package.id_order_carrier}">
                                        <input type="hidden" value="{Tools::getAdminTokenLite('AdminModules')}" name="_token">
                                    </form>
                                {else}
                                    <a href="{$package.downloadLabelLink}" class="btn btn-primary">Pobierz etykietę</a>
                                {/if}
                            </td>
                        </tr>
                    {/foreach}
                </tbody>
            </table>
        {/if}



    </div>
</div>
