<?php
if (!defined('_PS_VERSION_'))
    exit;

const _PAXY_API_URL = 'https://api.paxy.pl';
const _PAXY_WIDGET_API_URL = 'https://iai-bridge.paxy.pl/api/v1';

class Paxy extends Module
{
    public function __construct()
    {
        $this->name = 'paxy';
        $this->tab = 'shipping_logistics';
        $this->version = '1.5.3';
        $this->author = 'Paxy';
        $this->need_instance = 0;
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Paxy integration for presta 1.6.X');
        $this->description = $this->l('Paxy integration for presta 1.6.X.');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');

        if (!Configuration::get('paxy'))
            $this->warning = $this->l('No name provided');
    }

    public function install()
    {
        if (Shop::isFeatureActive()) {
            Shop::setContext(Shop::CONTEXT_ALL);
        }

        try {
            $this->updateDatabase();
        } catch (Exception $e) {}

        // Prepare tab
        $tab = new Tab();
        $tab->active = 0;
        $tab->class_name = 'AdminPaxyCarrier';
        $tab->name = array();
        foreach (Language::getLanguages(true) as $lang)
            $tab->name[$lang['id_lang']] = 'AdminPaxyCarrier';
        $tab->id_parent = -1;
        $tab->module = $this->name;

        $tab2 = new Tab();
        $tab2->active = 0;
        $tab2->class_name = 'AdminPaxyParcelType';
        $tab2->name = array();
        foreach (Language::getLanguages(true) as $lang)
            $tab2->name[$lang['id_lang']] = 'AdminPaxyParcelType';
        $tab2->id_parent = -1;
        $tab2->module = $this->name;

        $tab3 = new Tab();
        $tab3->active = 0;
        $tab3->class_name = 'AdminPaxyCreatePackage';
        $tab3->name = array();
        foreach (Language::getLanguages(true) as $lang)
            $tab3->name[$lang['id_lang']] = 'AdminPaxyCreatePackage';
        $tab3->id_parent = -1;
        $tab3->module = $this->name;

        $tab4 = new Tab();
        $tab4->active = 0;
        $tab4->class_name = 'AdminPaxyDownloadLabel';
        $tab4->name = array();
        foreach (Language::getLanguages(true) as $lang)
            $tab4->name[$lang['id_lang']] = 'AdminPaxyDownloadLabel';
        $tab4->id_parent = -1;
        $tab4->module = $this->name;

        if (!parent::install() || !$tab->add() || !$tab2->add() || !$tab3->add() || !$tab4->add() ||
            !$this->registerHook('actionValidateOrder') ||
            !$this->registerHook('actionCartSave') ||
            !$this->registerHook('leftColumn') ||
            !$this->registerHook('header') ||
            !$this->registerHook("displayBeforeCarrier") ||
            !$this->registerHook("displayAdminOrder") ||
            !$this->registerHook("displayAdminAfterHeader") ||
            !$this->registerHook("displayBackOfficeHeader") ||
            !Configuration::updateValue($this->name, 'my friend')
        ) {
            return false;
        }

        return true;
    }

    public function updateDatabase()
    {
        Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'carrier` ADD paxy_enabled BOOLEAN DEFAULT FALSE');
        Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'carrier` ADD paxy_country VARCHAR(100)');
        Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'carrier` ADD paxy_carrier VARCHAR(100)');
        Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'carrier` ADD paxy_type VARCHAR(100)');
        Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'carrier` ADD paxy_widget_point BOOLEAN DEFAULT FALSE');
        Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'carrier` ADD paxy_widget_point_type VARCHAR(100)');
        Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'cart` ADD paxy_pickup_point_id VARCHAR(100)');
        Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'order_carrier` ADD paxy_parcel_number VARCHAR(100)');
        Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'order_carrier` ADD paxy_pickup_point_id VARCHAR(100)');
        Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'order_carrier` ADD paxy_created DATETIME');
        Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'order_carrier` ADD paxy_should_regain_number DATETIME');
        Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'order_carrier` ADD paxy_pickup_point_details VARCHAR(1024) NULL DEFAULT NULL');
    }

    public function uninstall()
    {
        $sql = 'DESCRIBE '._DB_PREFIX_.'carrier';
        $columns = Db::getInstance()->executeS($sql);

        foreach($columns as $col){
            if($col['Field']=='paxy_enabled'){
                Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'carrier` DROP COLUMN paxy_enabled');
            }   elseif($col['Field']=='paxy_country') {
                Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'carrier` DROP COLUMN paxy_country');
            } elseif($col['Field']=='paxy_carrier') {
                Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'carrier` DROP COLUMN paxy_carrier');
            } elseif($col['Field']=='paxy_type') {
                Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'carrier` DROP COLUMN paxy_type');
            } elseif($col['Field']=='paxy_widget_point') {
                Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'carrier` DROP COLUMN paxy_widget_point');
            } elseif($col['Field']=='paxy_widget_point_type') {
                Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'carrier` DROP COLUMN paxy_widget_point_type');
            }
        }

        $sql = 'DESCRIBE '._DB_PREFIX_.'cart';
        $columnsCart =  Db::getInstance()->executeS($sql);
        foreach($columnsCart as $col){
            if($col['Field']=='paxy_pickup_point_id') {
                Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'cart` DROP COLUMN paxy_pickup_point_id');
            }
        }

        $sql = 'DESCRIBE '._DB_PREFIX_.'order_carrier';
        $columnsOrderCarrier =  Db::getInstance()->executeS($sql);
        foreach($columnsOrderCarrier as $col){
            if($col['Field']=='paxy_parcel_number'){
                Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'order_carrier` DROP COLUMN paxy_parcel_number');
            }   elseif($col['Field']=='paxy_pickup_point_id') {
                Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'order_carrier` DROP COLUMN paxy_pickup_point_id');
            }   elseif($col['Field']=='paxy_created') {
                Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'order_carrier` DROP COLUMN paxy_created');
            }   elseif($col['Field']=='paxy_should_regain_number') {
                Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'order_carrier` DROP COLUMN paxy_should_regain_number');
            }    elseif($col['Field']=='paxy_pickup_point_details') {
                Db::getInstance()->execute('ALTER TABLE `' . _DB_PREFIX_ . 'order_carrier` DROP COLUMN paxy_pickup_point_details');
            }
        }

        $id_tab = (int)Tab::getIdFromClassName('AdminPaxyCarrier');

        if ($id_tab)
        {
            $tab = new Tab($id_tab);
            $tab->delete();
        }

        $id_tab = (int)Tab::getIdFromClassName('AdminPaxyParcelType');

        if ($id_tab)
        {
            $tab = new Tab($id_tab);
            $tab->delete();
        }

        $id_tab = (int)Tab::getIdFromClassName('AdminPaxyCreatePackage');

        if ($id_tab)
        {
            $tab = new Tab($id_tab);
            $tab->delete();
        }

        $id_tab = (int)Tab::getIdFromClassName('AdminPaxyDownloadLabel');

        if ($id_tab)
        {
            $tab = new Tab($id_tab);
            $tab->delete();
        }

        if (!parent::uninstall() ||
            !Configuration::deleteByName($this->name)
        ) {
            return false;
        }

        return true;
    }

    public function hookDisplayHeader()
    {
        $this->context->controller->addJquery();
        $this->context->controller->addCss($this->_path.'css/paxywidget.css');
        $this->context->controller->addCss($this->_path.'css/paxypresta.css');
        $this->context->controller->addJS($this->_path.'js/paxyfront.js');
        $this->context->controller->addJS($this->_path.'js/paxywidget.js');

        Media::addJsDef([
            'paxy_carriers_ids' => json_encode($this->getIdCarriersWithPickupPoints()),
            'paxy_carriers' => json_encode($this->getCarriersWithPickupPoints()),
            'paxy_widget_token' => Configuration::get('paxy_widget_api_key'),
            'paxy_widget_api_url' =>  $this->context->link->getModuleLink('paxy', 'api'),
            'paxy_widget_lang' => !empty($this->context->language->iso_code) ? $this->context->language->iso_code : 'pl',
            'paxy_widget_dictionary' => [
                "select_point_title" => $this->l("Press button to select pickup point"),
                "select_point_button" => $this->l("Select pickup point"),
                "selected_pickup_point" => $this->l("Selected pickup point"),
                "selected_country" => $this->l("Selected country"),
                "show_details" => $this->l("Show details"),
                "reset_search" => $this->l("Reset search"),
                "search" => $this->l("Search"),
                "show_on_map" => $this->l("Show on map"),
                "select" => $this->l("Select"),
                "opening_hours" => $this->l("Opening hours"),
                "courier" => $this->l("Courier"),
                "monday" => $this->l("Monday"),
                "tuesday" => $this->l("Tuesday"),
                "wednesday" => $this->l("Wednesday"),
                "thursday" => $this->l("Thursday"),
                "friday" => $this->l("Friday"),
                "saturday" => $this->l("Saturday"),
                "sunday" => $this->l("Sunday"),
                "localize_me" => $this->l("Show my localization"),
                "search_input" => $this->l("Search"),
            ]
        ]);
    }

    public function hookActionCartSave($params)
    {
        if (!empty($_POST['paxy-pickup-point-id'])) {
            $SQL = "UPDATE "._DB_PREFIX_."cart SET paxy_pickup_point_id = '" . $_POST['paxy-pickup-point-id'] . "' WHERE id_cart = ".$params['cart']->id;
            DB::getInstance()->execute($SQL);
        }
    }

    public function hookActionValidateOrder($params)
    {
        $SQL = "SELECT * FROM " . _DB_PREFIX_ . "cart WHERE id_cart = " . $params['cart']->id;
        $cartData = DB::getInstance()->executeS($SQL);
        $SQL = "SELECT * FROM " . _DB_PREFIX_ . "carrier WHERE id_carrier = " . $params['cart']->id_carrier;
        $carrierData = DB::getInstance()->executeS($SQL);

        if (!empty($cartData) && isset($cartData[0]) && isset($cartData[0]['paxy_pickup_point_id'])) {
            $pickupPointId = $cartData[0]['paxy_pickup_point_id'];
            if ($pickupPointId) {
                $paxyWidgetPointDetails = "NULL";

                if (!empty($carrierData) && isset($carrierData[0]) && isset($carrierData[0]['paxy_widget_point_type'])) {
                    $paxyPickupPointCarrier = $carrierData[0]['paxy_widget_point_type'];

                    if ($paxyPickupPointCarrier) {
                        $pointDetailsResponse = $this->getPaxyWidgetPointDetails($paxyPickupPointCarrier, $pickupPointId);
                        if (!empty($pointDetailsResponse) && isset($pointDetailsResponse['body'])) {
                            $point = $pointDetailsResponse['body'];

                            $paxyWidgetPointDetails = implode(', ', [
                                $point['name'],
                                $point['lat'],
                                $point['lng'],
                                $point['address'],
                                $point['postCode'],
                                $point['city'],
                                $point['country'],
                            ]);
                        }
                    }
                }

                $SQL = "UPDATE " . _DB_PREFIX_ . "order_carrier SET paxy_pickup_point_id = '" . $pickupPointId . "', paxy_pickup_point_details = '" . $paxyWidgetPointDetails . "' WHERE id_order = " . $params['order']->id;
                DB::getInstance()->execute($SQL);
            }
        }
    }

    public function hookDisplayBackOfficeHeader()
    {
        $this->context->controller->addJquery();
        $this->context->controller->addJS($this->_path.'js/paxyadmin.js');
        Media::addJsDef(['paxyCarriersUrl' => $this->context->link->getAdminLink('AdminPaxyCarrier').'&ajax=1&action=categories']);
        Media::addJsDef(['paxyDimensionsUrl' => $this->context->link->getAdminLink('AdminPaxyParcelType').'&ajax=1']);
    }


    private function getPaxyCarriersWithPickupPoints() {
        $items = Carrier::getCarriers(!empty($this->context->language->iso_code) ? $this->context->language->iso_code : 'pl');
        $data = [];

        if (!empty($items)) {
            foreach ($items as $item) {
                if (isset($item['paxy_widget_point']) && intval($item['paxy_widget_point']) === 1) {
                    $data[] = $item;
                }
            }
        }

        return $data;
    }

    private function getIdCarriersWithPickupPoints() {
        $items = $this->getPaxyCarriersWithPickupPoints();
        $data = [];

        if (!empty($items)) {
            foreach ($items as $i) {
                $data[] = (int) $i['id_carrier'];
            }
        }

        return $data;
    }

    private function getCarriersWithPickupPoints() {
        $items = $this->getPaxyCarriersWithPickupPoints();
        $data = [];

        if (!empty($items)) {
            foreach ($items as $item) {
                $data[] = [
                    'id_carrier' => (int)$item['id_carrier'],
                    'widget_pickup_point' => $item['paxy_widget_point_type'],
                    'paxy_id' => (int)$item['paxy_carrier'],
                ];
            }
        }

        return $data;
    }
    public function getContent()
    {
        $output = null;

        if (Tools::isSubmit('submit'.$this->name)) {
            $paxy_api_key = Tools::getValue('paxy_api_key');
            $paxy_api_secret = Tools::getValue('paxy_api_secret');
            $paxy_widget_api_key = Tools::getValue('paxy_widget_api_key');
            if (
                !$paxy_api_key || !$paxy_api_secret || !$paxy_widget_api_key ||
                empty($paxy_api_key) || empty($paxy_api_secret) || empty($paxy_widget_api_key)
            ) {
                $output .= $this->displayError($this->l('Invalid Configuration value'));
            } else {
                Configuration::updateValue('paxy_api_key', $paxy_api_key);
                Configuration::updateValue('paxy_api_secret', $paxy_api_secret);
                Configuration::updateValue('paxy_widget_api_key', $paxy_widget_api_key);
                $output .= $this->displayConfirmation($this->l('Settings updated'));
            }
        }

        return $output.$this->displayForm();
    }

    public function displayForm()
    {
        $defaultLang = (int)Configuration::get('PS_LANG_DEFAULT');

        // Init Fields form array
        $fieldsForm[0]['form'] = [
            'legend' => [
                'title' => $this->l('Settings'),
            ],
            'input' => [
                [
                    'type' => 'text',
                    'label' => $this->l('Paxy - Api key'),
                    'name' => 'paxy_api_key',
                    'size' => 50,
                    'required' => true
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('Paxy - Api secret'),
                    'name' => 'paxy_api_secret',
                    'size' => 50,
                    'required' => true
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('Paxy widget - Api key'),
                    'name' => 'paxy_widget_api_key',
                    'size' => 50,
                    'required' => true
                ],
            ],
            'submit' => [
                'title' => $this->l('Save'),
                'class' => 'btn btn-default pull-right'
            ]
        ];

        $helper = new HelperForm();

        // Module, token and currentIndex
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

        // Language
        $helper->default_form_language = $defaultLang;
        $helper->allow_employee_form_lang = $defaultLang;

        // Title and toolbar
        $helper->title = $this->displayName;
        $helper->show_toolbar = true;        // false -> remove toolbar
        $helper->toolbar_scroll = true;      // yes - > Toolbar is always visible on the top of the screen.
        $helper->submit_action = 'submit'.$this->name;
        $helper->toolbar_btn = [
            'save' => [
                'desc' => $this->l('Save'),
                'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.
                    '&token='.Tools::getAdminTokenLite('AdminModules'),
            ],
            'back' => [
                'href' => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules'),
                'desc' => $this->l('Back to list')
            ]
        ];

        // Load current value
        $helper->fields_value['paxy_api_key'] = Tools::getValue('paxy_api_key', Configuration::get('paxy_api_key'));
        $helper->fields_value['paxy_api_secret'] = Tools::getValue('paxy_api_secret', Configuration::get('paxy_api_secret'));
        $helper->fields_value['paxy_widget_api_key'] = Tools::getValue('paxy_widget_api_key', Configuration::get('paxy_widget_api_key'));

        return $helper->generateForm($fieldsForm);
    }

    public function hookDisplayAdminOrder($param)
    {
        $idOrder = $param['id_order'];

        $sql2 = new DbQuery();
        $sql2->from('order_carrier', 'oc');
        $sql2->where('oc.id_order = '.$idOrder);
        $orderCarrier = Db::getInstance()->executeS($sql2);
        $orderCarrierPickupPointId = null;
        if (isset($orderCarrier[0])) {
            if (!empty($orderCarrier[0]['paxy_should_regain_number'])) {
                $date = new DateTime($orderCarrier[0]['paxy_should_regain_number']);
                $now = new DateTime();
                $diff = $now->getTimestamp() - $date->getTimestamp();
                if ($diff > 20) {
                    $data = $this->getPaxyParcelStatus($orderCarrier[0]['paxy_parcel_number'], true)[0];
                    DB::getInstance()->update('order_carrier', [
                        'paxy_parcel_number' => $data['trackingNr'],
                        'paxy_should_regain_number' => null
                    ], 'id_order_carrier = ' . $orderCarrier[0]['id_order_carrier']);
                }
            }
            if (!empty($orderCarrier[0]['paxy_pickup_point_id'])) {
                $orderCarrierPickupPointId = $orderCarrier[0]['paxy_pickup_point_id'];
            }
        }


        $sql = new DbQuery();
        $sql->select('oc.id_order_carrier, oc.paxy_parcel_number, carrier.name, oc.weight, oc.paxy_created');
        $sql->from('order_carrier', 'oc');
        $sql->innerJoin('carrier', 'carrier', 'carrier.id_carrier = oc.id_carrier');
        $sql->where('oc.id_order = '.$idOrder);
        $sql->where('carrier.paxy_enabled = 1');
        $packages = Db::getInstance()->executeS($sql);


        foreach ($packages as $key => $package) {
            $sql = new DbQuery();
            $sql->select('d.weight');
            $sql->from('order_carrier', 'd');
            $sql->where('d.id_order_carrier = '.$package['id_order_carrier']);
            $details = Db::getInstance()->executeS($sql);
            $packageWeight = $details[0]['weight'];
            $packageWeight = round((float) $packageWeight, 1);
            $packages[$key]['weight'] = $packageWeight;

            $packages[$key]['id_order_carrier'] = $package['id_order_carrier'];
            $packages[$key]['createPackageLink'] = $this->context->link->getAdminLink('AdminPaxyCreatePackage').'&id_order_carrier='.$package['id_order_carrier'];
            if (!empty($package['paxy_parcel_number']))  {
                $packages[$key]['downloadLabelLink'] = $this->context->link->getAdminLink('AdminPaxyDownloadLabel').'&id_order_carrier='. $package['id_order_carrier'];
                $packages[$key]['paxyStatus'] = $this->getPaxyParcelStatus($package['paxy_parcel_number']);
            }

        }

        $order = new Order($idOrder);
        $cod = false;
        if ($order->module === 'cashondelivery') {
            $cod = round((float) $order->total_paid, 2);
        }

        $errorMessage = null;
        if (isset($_SESSION["error_paxy_parcel"])) {
            $errorMessage = $_SESSION["error_paxy_parcel"];
            $_SESSION["error_paxy_parcel"] = null;
        }

        $successMessage = null;
        if (isset($_SESSION['error_paxy_parcel_created'])) {
            $successMessage = $_SESSION['error_paxy_parcel_created'];
            $_SESSION['error_paxy_parcel_created'] = null;
        }


        $carrierSql = new DbQuery();
        $carrierSql->from('carrier', 'c');
        $carrierSql->where('c.id_carrier = '.$order->id_carrier);
        $carrier = Db::getInstance()->executeS($carrierSql)[0];

        $this->context->smarty->assign([
            'carrier' => $carrier,
            'packages' => $packages,
            'packagesLength' => count($packages),
            'cod' => $cod,
            'pickupPointId' => $orderCarrierPickupPointId,
            'errorMessage' => $errorMessage,
            'successMessage' => $successMessage
        ]);

        return $this->display(__FILE__, 'display_admin_order.tpl');
    }

    private function getPaxyParcelStatus($paxy_parcel_number, $returnAll = false)
    {
        $apiKey = Configuration::get('paxy_api_key');
        $apiSecret = Configuration::get('paxy_api_secret');
        $ch = curl_init();
        $endpoint = _PAXY_API_URL . '/przesylki/statusy';
        $params = array(
            'trackingNrs' => [
                $paxy_parcel_number
            ]
        );
        $url = $endpoint . '?' . http_build_query($params);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "CL-API-KEY: $apiKey",
            "CL-API-TOKEN: $apiSecret",
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_AUTOREFERER, true);
        $result = curl_exec($ch);
        $result = json_decode($result, true);
        if ($returnAll) {
            return $result;
        }
        return $result[0]['label'];
    }

    private function getPaxyWidgetPointDetails($carrier, $pickupPointId)
    {
        $apiKey = Configuration::get('paxy_widget_api_key');
        $url = _PAXY_WIDGET_API_URL . "/paxyWidget/points/$carrier/$pickupPointId";
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "token: $apiKey",
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_AUTOREFERER, true);
        $result = curl_exec($ch);
        return json_decode($result, true);
    }

}
