<?php
class AdminCarrierWizardController extends AdminCarrierWizardControllerCore
{
    public function renderStepOne($carrier)
    {
        $this->fields_form = array(
            'form' => array(
                'id_form' => 'step_carrier_general',
                'input' => array(
                    array(
                        'type' => 'text',
                        'label' => $this->l('Carrier name'),
                        'name' => 'name',
                        'required' => true,
                        'hint' => array(
                            $this->l('Allowed characters: letters, spaces and "%special_chars%".'),
                            $this->l('The carrier\'s name will be displayed during checkout.'),
                            $this->l('For in-store pickup, enter 0 to replace the carrier name with your shop name.'),
                        ),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Transit time'),
                        'name' => 'delay',
                        'lang' => true,
                        'required' => true,
                        'maxlength' => 512,
                        'hint' => $this->l('The delivery time will be displayed during checkout.'),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Speed grade'),
                        'name' => 'grade',
                        'required' => false,
                        'size' => 1,
                        'hint' => $this->l('Enter "0" for a longest shipping delay, or "9" for the shortest shipping delay.'),
                    ),
                    array(
                        'type' => 'logo',
                        'label' => $this->l('Logo'),
                        'name' => 'logo',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Tracking URL'),
                        'name' => 'url',
                        'hint' => $this->l('Delivery tracking URL: Type \'@\' where the tracking number should appear. It will be automatically replaced by the tracking number.'),
                        'desc' => $this->l('For example: \'http://example.com/track.php?num=@\' with \'@\' where the tracking number should appear.'),
                    ),
                    array(
                        'label' => $this->l('Integracja paxy'),
                        'type' => 'switch',
                        'name' => 'paxy_enabled',
                        'required' => false,
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'shipping_handling_on',
                                'value' => 1,
                                'label' => $this->l('Enabled'),
                            ),
                            array(
                                'id' => 'shipping_handling_off',
                                'value' => 0,
                                'label' => $this->l('Disabled'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'select',
                        'options' => [
                            'id' => 'id',
                            'name' => 'name',
                            'query' => $this->loadCountries()
                        ],
                        'label' => $this->l('Paxy - Kraj'),
                        'name' => 'paxy_country',
                        'required' => false,
                        'hint' => array(),
                        'value' => $carrier->paxy_country ? $carrier->paxy_country : null
                    ),
                    array(
                        'type' => 'select',
                        'options' => [
                            'id' => 'id',
                            'name' => 'name',
                            'query' => $carrier->paxy_country !== null ? $this->loadCarriers($carrier->paxy_country) : []
                        ],
                        'label' => $this->l('Paxy - przewoźnik'),
                        'name' => 'paxy_carrier',
                        'required' => false,
                        'hint' => array(),
                        'value' => $carrier->paxy_carrier ? $carrier->paxy_carrier : null
                    ),
                    array(
                        'type' => 'select',
                        'options' => [
                            'id' => 'id',
                            'name' => 'name',
                            'query' => $carrier->paxy_country !== null && $carrier->paxy_carrier !== null ? $this->loadDimensions($carrier->paxy_country, $carrier->paxy_carrier) : []
                        ],
                        'label' => $this->l('Paxy - typ paczki'),
                        'name' => 'paxy_type',
                        'required' => false,
                        'hint' => array(),
                        'value' => $carrier->paxy_type ? $carrier->paxy_type : null
                    ),
                    array(
                        'label' => $this->l('Czy jest to pickup point'),
                        'type' => 'switch',
                        'name' => 'paxy_widget_point',
                        'required' => false,
                        'is_bool' => true,
                        'values' => array(
                            array(
                                'id' => 'paxy_widget_point_on',
                                'value' => 1,
                                'label' => $this->l('Enabled'),
                            ),
                            array(
                                'id' => 'paxy_widget_point_off',
                                'value' => 0,
                                'label' => $this->l('Disabled'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'select',
                        'options' => [
                            'id' => 'id',
                            'name' => 'name',
                            'query' => $this->loadPickupPointTypes()
                        ],
                        'label' => $this->l('Pickup point'),
                        'name' => 'paxy_widget_point_type',
                        'required' => false,
                        'hint' => array(),
                        'value' => $carrier->paxy_widget_point_type ? $carrier->paxy_widget_point_type : null
                    )
                ),
            ),
        );
        $tpl_vars = array('max_image_size' => (int) Configuration::get('PS_PRODUCT_PICTURE_MAX_SIZE') / 1024 / 1024);
        $fields_value = $this->getStepOneFieldsValues($carrier);
        return $this->renderGenericForm(array('form' => $this->fields_form), $fields_value, $tpl_vars);
    }

    public function getStepOneFieldsValues($carrier)
    {
        $fieldValues = parent::getStepOneFieldsValues($carrier);
        $fieldValues['paxy_country'] = $this->getFieldValue($carrier, 'paxy_country');
        $fieldValues['paxy_type'] = $this->getFieldValue($carrier, 'paxy_type');
        $fieldValues['paxy_carrier'] = $this->getFieldValue($carrier, 'paxy_carrier');
        $fieldValues['paxy_enabled'] = $this->getFieldValue($carrier, 'paxy_enabled');
        $fieldValues['paxy_widget_point'] = $this->getFieldValue($carrier, 'paxy_widget_point');
        $fieldValues['paxy_widget_point_type'] = $this->getFieldValue($carrier, 'paxy_widget_point_type');
        return $fieldValues;
    }

    private function loadCountries()
    {
        $apiKey = Configuration::get('paxy_api_key');
        $apiSecret = Configuration::get('paxy_api_secret');
        $ch = curl_init(_PAXY_API_URL . "/country/");
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "CL-API-KEY: $apiKey",
            "CL-API-TOKEN: $apiSecret",
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $apiResponse = curl_exec($ch);
        curl_close($ch);
        if ($apiResponse) {
            $response = json_decode($apiResponse, true);
            $countries = [
                "id" => null,
                "code" => null,
                "name" => ""
            ];
            return array_merge($countries, $response['countries']);
        }

        return [];
    }

    private function loadPickupPointTypes()
    {
        $apiKey = Configuration::get('paxy_widget_api_key');
        $ch = curl_init(_PAXY_WIDGET_API_URL . "/paxyWidget/carriers");
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "token: $apiKey",
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $apiResponse = curl_exec($ch);
        curl_close($ch);
        if ($apiResponse) {
            $response = json_decode($apiResponse, true);
            $data = [];
            $data[] = [
                'id' => null,
                'name' => null,
            ];
            foreach ($response['body'] as $item) {
                $data[] = [
                    'id' => $item,
                    'name' => $this->mapPointValueToLabel($item),
                ];
            }
            return $data;
        }

        return [];
    }

    private function mapPointValueToLabel($value)
    {
        switch ($value) {
            case "cp_balikovna":
                return "Balíkovna - Česká pošta";
            case "cp_napostu":
                return "Balík Na poštu - Česká pošta";
            case "sps_parcelshop_":
                return "SPS ParcelShop";
            case "sps_balikomat_":
                return "SPS Balikomat";
            case "econt":
                return "Econt Office";
            case "sameday":
                return "SameDay (RO)";
            case "samedayhu":
                return "SameDay (HU)";
            case "samedaybg_":
                return "SameDay (BG)";
            case "wedo_point_":
                return "WeDo Point";
            case "wedo_box_":
                return "WeDo Box";
            case "sppoczta":
                return "Slovenská pošta";
            case "sppoczta_office_":
                return "Balík na poštu - Slovenská pošta";
            case "sppoczta_point_":
                return "BalíkoBOX - Slovenská pošta";
            case "mpl_office_":
                return "Csomagautomata - Magyar Posta";
            case "mpl_point_":
                return "PostaPont - Magyar Posta";
            case "mpl_postapont_":
                return "PostaPont - Magyar Posta";
            case "mpl_csomagautomata_":
                return "Csomagautomata - Magyar Posta";
            case "lpexpress":
                return "LPExpress Point";
            case "sp_point_":
                return "Balík na poštu - Slovenská pošta";
            case "sp_office_":
                return "BalíkoBOX - Slovenská pošta";
            case "postask_napostu_":
                return "Balík na poštu - Slovenská pošta";
            case "postask_balikobox_":
                return "BalíkoBOX - Slovenská pošta";
            case "ppl_parcelbox_":
                return "PPL ParcelBox";
            case "ppl_parcelshop_":
                return "PPL ParcelShop";
            case "fancourier_fanbox_":
                return "FanCourier FanBOX";
            case "fancourier_point_":
                return "FanCourier Point";
            case "fancourier_collectpoint_":
                return "FanCourier CollectPoint";
            case "venipaklt_locker_":
                return "Venipak Locker (LT)";
            case "venipaklt_pickup_":
                return "Venipak Pickup (LT)";
            case "venipaklv_locker_":
                return "Venipak Locker (LV)";
            case "venipaklv_pickup_":
                return "Venipak Pickup (LV)";
            case "venipakee_locker_":
                return "Venipak Locker (EE)";
            case "venipakee_pickup_":
                return "Venipak Pickup (EE)";
            case "postahr_napostu_":
                return "Post Office - Hrvatska pošta";
            case "postahr_paketomat_":
                return "Paketomat - Hrvatska pošta";
            case "cargus_":
                return "Cargus Locker";
            case "hermes_":
                return "Hermes Paketversand";
            case "posteitaliane_":
                return "Poste Italiane";
            case "postnordse_":
                return "PostNord (SE)";
            case "postnordfi_":
                return "PostNord (FI)";
            case "postnorddk_":
                return "PostNord (DK)";
            default:
                return $value;
        }
    }

    private function loadCarriers($countryId)
    {
        $apiKey = Configuration::get('paxy_api_key');
        $apiSecret = Configuration::get('paxy_api_secret');
        $ch = curl_init();
        $endpoint = _PAXY_API_URL . '/carrier/country/'.$countryId;
        $params = array(
            'countryId' => $countryId
        );
        $url = $endpoint . '?' . http_build_query($params);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "CL-API-KEY: $apiKey",
            "CL-API-TOKEN: $apiSecret",
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $apiResponse = curl_exec($ch);
        curl_close($ch);
        if ($apiResponse) {
            $response = json_decode($apiResponse, true);
            return $response['carriers'];
        }
        return [];
    }

    private function loadDimensions($countryId, $carrierId)
    {
        $apiKey = Configuration::get('paxy_api_key');
        $apiSecret = Configuration::get('paxy_api_secret');
        $ch = curl_init();
        $endpoint = _PAXY_API_URL . '/dimension/';
        $params = array(
            'countryId' => $countryId,
            'carrierId' => $carrierId,
        );
        $url = $endpoint . '?' . http_build_query($params);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "CL-API-KEY: $apiKey",
            "CL-API-TOKEN: $apiSecret",
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $apiResponse = curl_exec($ch);
        curl_close($ch);
        if ($apiResponse) {
            $response = json_decode($apiResponse, true);
            $categories = $response['categories'];
            $ret = [];
            foreach ($categories as $category) {
                $ret[] = [
                    'id' => $category['id'],
                    'name' => $category['label']
                ];
            }
            return $ret;
        }
        return [];
    }
}
