window.onload = function() {
    window.addEventListener("paxyWidgetInitialized", function(e) {
        window.isPaxyInit = true;
    })

    window.addEventListener('paxyWidgetPointSelected', function (e) {
        $('[data-paxy-selected-point-details]').html('');
        $('[data-paxy-selected-point-details]').append(`
            <p>
              <strong>${window.paxy_widget_dictionary?.['selected_pickup_point'] ?? 'Wybrany punkt pickup'}:</strong>
            </p>
            <p>
              ${e.detail.name}
            </p>
            <p>
              ${e.detail. address}
            </p>
            <p>
              ${e.detail.postCode} ${e.detail.city}
            </p>
        `)
        $('[data-paxy-pickup-point-id]').val(e.detail.id);
        window.dispatchEvent(new CustomEvent('paxyWidgetClose'));
        $('button[name="processCarrier"]').attr('disabled', false);
    });

    $(document).ready(function() {
        var pickupPointCarriersIds = JSON.parse(paxy_carriers_ids);
        var pickupPointCarriers = JSON.parse(paxy_carriers);
        var deliveryinput = $('.delivery_option');

        if (deliveryinput.length > 0) {
            $('body').append('<paxy-widget></paxy-widget>')
            var form = $('.delivery_options');
            form.after(`<div class="paxy-widget-select-point" data-paxy-section><div style="color:red; font-weight: bold; margin-bottom: 10px;">${window.paxy_widget_dictionary?.['select_point_title'] ?? 'Kliknij w przycisk aby wybrać punkt'}<br></div><button class="paxy-select-point-button" type="button" data-paxy-select-point>${window.paxy_widget_dictionary?.['select_point_button'] ?? 'Wybierz punkt pickup'}</button><div data-paxy-selected-point-details class="paxy-point-selected"></div></div><input type="hidden" data-paxy-pickup-point-id name="paxy-pickup-point-id">`);

            window.dispatchEvent(new CustomEvent('paxyWidgetBootstrap'));
            setTimeout(() => {
                handleDeliveryChange();
            }, 1000);

            $('.delivery_option').find('input[type="radio"]').on('change', function() {
                if ($(this).is(':checked')) {
                    handleDeliveryChange()
                }
            })
        }

        $(document).on('click', '[data-paxy-select-point]', function(e) {
            $(e.target).attr('disabled', true)
            $(e.target).prepend('<div class="lds-dual-ring"></div>')
            openWidget();
            setTimeout(function() {
                $(e.target).attr('disabled', false);
                $(e.target).find('.lds-dual-ring').remove();
            }, 2500)
        })

        function openWidget() {
            if (window.isPaxyInit && window.paxySelectedCourierPoint) {
                window.dispatchEvent(new CustomEvent('paxyWidgetOpen'));
            }   else {
                console.error('could not open paxy widget due to the fact that it was not initialized')
            }
        }

        function setWidgetConfig() {
            if (window.isPaxyInit && window.paxySelectedCourierPoint) {
                window.paxyWidget.setWidgetConfig({
                    pickupPointsFullUrl: window.paxy_widget_api_url,
                    componentType: "modal",
                    couriers: [window.paxySelectedCourierPoint],
                    language: window.paxy_widget_lang,
                    dictionary: window.paxy_widget_dictionary,
                    token: window.paxy_widget_token,
                    showCouriersSelectInput: false,
                    assetsPathPrefix: 'modules/paxy/'
                })
            }
        }

        function handleDeliveryChange() {
            $('[data-paxy-selected-point-details]').html('');
            var checkedDeliveryValue = $('.delivery_option').find('input[type="radio"]:checked').val();
            checkedDeliveryValue = checkedDeliveryValue ? checkedDeliveryValue.replace(',', '') : undefined;
            if (checkedDeliveryValue && pickupPointCarriersIds.includes(-(-(checkedDeliveryValue)))) {
                $('[data-paxy-section]').show();
                const item = pickupPointCarriers.find(function(point) {
                    return point.id_carrier ===  -(-(checkedDeliveryValue))
                })
                window.paxySelectedCourierPoint = item.widget_pickup_point;
                setWidgetConfig();
                $('button[name="processCarrier"]').attr('disabled', true);
            }   else {
                $('[data-paxy-section]').hide();
                $('[data-paxy-selected-point-details]').html('');
                window.paxySelectedCourierPoint = undefined;
                $('button[name="processCarrier"]').attr('disabled', false);
            }
        }

    })

}
