window.onload = function() {
    var el = document.querySelectorAll('#paxy_enabled_on');
    if (window.jQuery && el.length > 0) {
        function getPaxyCountry() {
            return $('#paxy_country');
        }

        function getPaxyPackageType() {
            return $('#paxy_type');
        }

        function getCzechlogisitcCarrier() {
            return $('#paxy_carrier');
        }

        function getPaxyEnabled() {
            return $('input[name="paxy_enabled"]');
        }

        function getPaxyEnabledValue() {
            var el = $('input[name="paxy_enabled"]:checked');
            return -(-(el.val()));
        }

        function disablePaxyInputs(disable = true) {
            getPaxyCountry().attr('disabled', disable);
            getCzechlogisitcCarrier().attr('disabled', disable);
            getPaxyPackageType().attr('disabled', disable);
        }

        getPaxyEnabled().on('change', function() {
            if (getPaxyEnabledValue() === 1) {
                disablePaxyInputs(false);
            }   else {
                disablePaxyInputs(true);
            }
        });

        function paxyInit() {
            if (getPaxyCountry().val() === undefined && getPaxyCountry().val() === null) {
                getPaxyCountry().val([]);
                getCzechlogisitcCarrier().val([]);
                getPaxyPackageType().val([]);
                if (getPaxyEnabledValue() === 1) {
                    disablePaxyInputs(false);
                }   else {
                    disablePaxyInputs(true);
                }
            }
        }

        paxyInit();

        getPaxyCountry().on('change', function() {
            getCzechlogisitcCarrier().val([]);
            getPaxyPackageType().val([]);
            paxyLoadCarriers($(this).val());
        });

        getCzechlogisitcCarrier().on('change', function() {
            getPaxyPackageType().val([]);
            paxyLoadParcelTypes($(this).val());
        })

        function paxyLoadCarriers(countryId) {
            if (countryId === undefined || countryId === null) return;

            $.ajax({
                url: paxyCarriersUrl,
                data: {
                    'countryId': countryId
                },
                success: function (resp) {
                    handleCarriersResponse(JSON.parse(resp));
                },
                error: function (resp) {

                }
            })
        }

        function handleCarriersResponse(resp) {
            var czechlogisitcCarrier = getCzechlogisitcCarrier();
            czechlogisitcCarrier.html('');
            czechlogisitcCarrier.append(`<option></option>`);
            if (resp !== undefined && resp !== null && resp.length > 0) {
                resp.map(function (carrier) {
                    czechlogisitcCarrier.append(`<option value="${carrier.id}">${carrier.name}</option>`);
                })
            }

        }

        function paxyLoadParcelTypes(carrierId) {
            if (carrierId === undefined || carrierId === null) return;

            $.ajax({
                url: paxyDimensionsUrl,
                data: {
                    'countryId': getPaxyCountry().val(),
                    'carrierId': carrierId,
                },
                success: function (resp) {
                    handleParcelTypesResponse(JSON.parse(resp));
                },
                error: function (resp) {

                }
            })
        }

        function handleParcelTypesResponse(resp) {
            var czechlogisitcParcelType = getPaxyPackageType();
            czechlogisitcParcelType.html('');
            if (resp.dimensions !== undefined && resp.dimensions !== null && resp.dimensions.length > 0) {
                resp.dimensions.map(function (dimension) {
                    czechlogisitcParcelType.append(`<option value="${dimension.id}">${dimension.name}</option>`);
                });
            }
        }
    }
}
