<?php
/*
Plugin Name: Paxy
Description: Paxy pickup points widget and api integration.
Version: 0.1
Author: Arkadiusz Pastuszka
Author URI: https://arekpastuszka.pl
Text Domain: paxy
Domain Path: /languages
*/

if (!function_exists('add_action')) {
    echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
    exit;
}

define('PX_VERSION', '0.1');
define('PX_DB_VERSION', '0.1');
define('PX__MINIMUM_WP_VERSION', '3.1');
define('PX__PLUGIN_URL', plugin_dir_url(__FILE__));
define('PX__PLUGIN_DIR', plugin_dir_path(__FILE__));
define('PX_BASENAME', plugin_basename(__FILE__));

define('PX_API_URL', 'https://api.paxy.pl');
define('PX_WIDGET_API_URL', 'https://iai-bridge.paxy.pl/api/v1');

register_activation_hook(__FILE__, ['Paxy', 'plugin_activation']);
register_deactivation_hook(__FILE__, ['Paxy', 'plugin_deactivation']);

require_once(PX__PLUGIN_DIR . 'class.paxy.php');
add_action('plugins_loaded', ['Paxy', 'init']);

if (is_admin()) {
    require_once(PX__PLUGIN_DIR . 'class.paxy-admin.php');
    add_action('init', ['PaxyAdmin', 'init']);
}

/*$apiClient = Paxy::get_api_client();
print_r($apiClient->get_countries());
print_r($apiClient->get_country(9));
print_r($apiClient->get_carrier(31));
print_r($apiClient->get_carriers_for_country(9));
print_r($apiClient->get_dimensions(9, 31));*/
/*$widgetClient = Paxy::get_widget_client();
print_r($widgetClient->get_countries());
print_r($widgetClient->get_carriers());
print_r($widgetClient->parse_point_id('econt2993'));
print_r($widgetClient->find_point('econt', 'econt2993'));
print_r($widgetClient->list_points('econt'));*/
