jQuery(function ($) {
    if (typeof paxyData === 'undefined') {
        return;
    }

    function updateSelectedPoint(point, shippingMethodId) {
        var $container = $('.paxy-pickup-point-container');
        if ($container.length) {
            var pointId = point.id;
            var carrier = point.courier;
            var details = [point.name, point.address, point.lat, point.lng, point.postCode, point.city, point.country].join(', ');

            $container.find('.paxy-pickup-point-id').val(pointId);
            $container.find('.paxy-pickup-point-carrier').val(carrier);
            $container.find('.paxy-pickup-point-details').val(details);
            $container.find('.paxy-pickup-point-info').html(
                '<p class="paxy-pickup-point-info-title">' + paxyData.selectedPointLabel + ':</p>' +
                '<p class="paxy-pickup-point-info-name">' + point.name + '</p>' +
                '<p class="paxy-pickup-point-info-address">' + point.address + '</p>' +
                '<p class="paxy-pickup-point-info-city">' + [point.postCode, point.city].join(' ') + '</p>'
            );

            // Store pickup point data in localStorage with shipping method ID as key
            if (shippingMethodId) {
                var storageKey = 'paxy_pickup_point_' + shippingMethodId;
                try {
                    localStorage.setItem(storageKey, JSON.stringify(point));
                } catch (e) {
                    console.error('Error saving pickup point to localStorage:', e);
                }
            }

            // Sync with WC Blocks Store API
            setExtensionData({
                paxy_pickup_point_id: pointId,
                paxy_pickup_point_carrier: carrier,
                paxy_pickup_point_details: details
            });

            $(document.body).trigger('update_checkout');
        }
    }

    function getStoredPickupPoint(shippingMethodId) {
        if (!shippingMethodId) {
            return null;
        }

        var storageKey = 'paxy_pickup_point_' + shippingMethodId;
        try {
            var storedData = localStorage.getItem(storageKey);
            return storedData ? JSON.parse(storedData) : null;
        } catch (e) {
            console.error('Error retrieving pickup point from localStorage:', e);
            return null;
        }
    }

    function updatePickupPointButton() {
        // Handle Legacy Checkout
        var legacyPaxySelected = false;
        $('ul#shipping_method li, .woocommerce-shipping-methods li').each(function () {
            var $parent = $(this);
            var $radio = $parent.find('input[type="radio"]');

            if ($radio.length && $radio.is(':checked')) {
                var methodId = $radio.val();

                if (paxyData.shippingMethods[methodId]) {
                    legacyPaxySelected = true;
                    if (!$parent.find('.paxy-pickup-point-container').length) {
                        renderPickupPointButton($parent, methodId, paxyData.shippingMethods[methodId]);
                    }
                } else {
                    $parent.find('.paxy-pickup-point-container').remove();
                }
            } else {
                $parent.find('.paxy-pickup-point-container').remove();
            }
        });

        // If we are in legacy mode (elements exist) and no Paxy method is selected, clear data.
        if ($('ul#shipping_method li, .woocommerce-shipping-methods li').length && !legacyPaxySelected) {
            clearExtensionData();
        }

        // Handle Blocks Checkout
        $('.wc-block-components-shipping-rates-control__package').each(function () {
            var $wrapper = $(this);
            var $checkedRadio = $wrapper.find('input[type="radio"]:checked');
            var checkedMethodId = $checkedRadio.val();
            var isPaxySelected = checkedMethodId && paxyData.shippingMethods[checkedMethodId];

            $wrapper.find('input[type="radio"]').each(function () {
                var $radio = $(this);
                var methodId = $radio.val();

                // Logic for Paxy methods (checked or unchecked)
                if (paxyData.shippingMethods[methodId]) {
                    var $parent = $radio.closest('.wc-block-components-radio-control__option').find('.wc-block-components-radio-control__option-layout');

                    if ($radio.is(':checked')) {
                        // Active Paxy Method: Render button if not present
                        if ($parent.length && !$parent.find('.paxy-pickup-point-container').length) {
                            renderPickupPointButton($parent, methodId, paxyData.shippingMethods[methodId]);
                        }
                        // Note: renderPickupPointButton handles setting/clearing data based on stored point
                    } else {
                        // Inactive Paxy Method: Remove button
                        $parent.find('.paxy-pickup-point-container').remove();
                    }
                } else {
                    // Non-Paxy Method
                    // We might need to cleanup if we injected something (unlikely for non-paxy but safe to check)
                    var $option = $radio.closest('.wc-block-components-radio-control__option');
                    $option.find('.paxy-pickup-point-container').remove();
                }
            });

            // Global Extension Data Logic based on the winning selection
            if (!isPaxySelected) {
                // If the selected method is NOT Paxy, we must clear the data.
                // This runs once per package update, ensuring no race condition from the loop.
                clearExtensionData();
            }
            // If Paxy IS selected, renderPickupPointButton (called in the loop above) will handle setting data or clearing if empty.
        });
    }

    function setExtensionData(data) {
        if (window.wp && window.wp.data && window.wp.data.dispatch) {
            // Try both checkout and cart stores just to be safe, though checkout is the primary target for this hook
            // Note: In newer WC Blocks, 'wc/store/checkout' is the main store for checkout data
            try {
                window.wp.data.dispatch('wc/store/checkout').setExtensionData('paxy-shipping', data);
            } catch (e) {
                console.warn('Could not dispatch to wc/store/checkout', e);
            }
        }
    }

    function clearExtensionData() {
        setExtensionData({});
    }

    function renderPickupPointButton($container, methodId, shippingMethodData) {
        window.paxyWidget.setWidgetConfig({
            pickupPointsFullUrl: paxyData.widgetApiUrl,
            componentType: "modal",
            couriers: [shippingMethodData.carrier],
            language: paxyData.widgetLang,
            showCouriersSelectInput: false,
            assetsPathPrefix: paxyData.widgetAssetsUrl
        });

        var $buttonHtml = $('<div class="paxy-pickup-point-container">' +
            '<input type="hidden" name="paxy_pickup_point_id" class="paxy-pickup-point-id" value="" required>' +
            '<input type="hidden" name="paxy_pickup_point_carrier" class="paxy-pickup-point-carrier" value="">' +
            '<input type="hidden" name="paxy_pickup_point_details" class="paxy-pickup-point-details" value="">' +
            '<button type="button" class="paxy-pickup-point-btn" ' +
            'data-instance-id="' + shippingMethodData.instanceId + '" data-carrier="' + shippingMethodData.carrier + '" ' +
            'data-method-id="' + methodId + '">' +
            paxyData.choosePointLabel + '</button>' +
            '<div class="paxy-pickup-point-info"></div>' +
            '</div>');

        $container.append($buttonHtml);

        // Load stored pickup point data if available
        var storedPoint = getStoredPickupPoint(methodId);
        if (storedPoint) {
            updateSelectedPoint(storedPoint, methodId);
        } else {
            clearExtensionData();
        }
    }

    var currentShippingMethodId = null;

    $(document.body).append('<paxy-widget></paxy-widget>')
    window.dispatchEvent(new CustomEvent('paxyWidgetBootstrap'));

    window.addEventListener("paxyWidgetInitialized", function (e) {
        updatePickupPointButton();
    });

    window.addEventListener('paxyWidgetPointSelected', function (e) {
        updateSelectedPoint(e.detail, currentShippingMethodId);
        window.dispatchEvent(new CustomEvent('paxyWidgetClose'));
    });

    $(document.body).on('updated_checkout', function () {
        updatePickupPointButton();
    });

    $('.wc-block-components-shipping-rates-control__package').on('change', 'input[type="radio"]', function () {
        updatePickupPointButton();
    });

    $(document).on('click', '.paxy-pickup-point-btn', function (e) {
        e.preventDefault();

        // Store the shipping method ID for use when point is selected
        currentShippingMethodId = $(this).data('method-id');

        window.dispatchEvent(new CustomEvent('paxyWidgetOpen'));
    });
});
