jQuery(function ($) {
    // Helper to find the next select field by name pattern
    function findNextField($el, namePart) {
        return $el.closest('.wc-shipping-zone-method-fields').find('select[name*="' + namePart + '"]');
    }

    // Handle Country Change
    $(document.body).on('change', 'select[name*="woocommerce_paxy_shipping_country"]', function () {
        var $countrySelect = $(this);
        var $carrierSelect = findNextField($countrySelect, 'woocommerce_paxy_shipping_carrier');
        var $typeSelect = findNextField($countrySelect, 'woocommerce_paxy_shipping_package_type');
        var countryId = $countrySelect.val();

        // Clear dependent fields
        $carrierSelect.empty().append('<option value="">' + paxy_admin_i18n.select_carrier + '</option>');
        $typeSelect.empty().append('<option value="">' + paxy_admin_i18n.select_type + '</option>');

        if (!countryId) {
            $carrierSelect.append('<option value="">' + paxy_admin_i18n.select_country_first + '</option>');
            return;
        }

        $carrierSelect.prop('disabled', true).empty().append('<option value="">' + paxy_admin_i18n.loading_carriers + '</option>');

        $.ajax({
            url: paxy_admin.ajax_url,
            type: 'GET',
            data: {
                action: 'px_get_carriers',
                country_id: countryId,
                nonce: paxy_admin.nonce
            },
            success: function (response) {
                if (response.success) {
                    $carrierSelect.empty().append('<option value="">' + paxy_admin_i18n.select_carrier + '</option>');
                    $.each(response.data, function (index, carrier) {
                        $carrierSelect.append('<option value="' + carrier.id + '">' + carrier.name + '</option>');
                    });
                } else {
                    $carrierSelect.empty().append('<option value="">' + response.data + '</option>');
                }
            },
            error: function () {
                $carrierSelect.empty().append('<option value="">Error loading carriers</option>');
            },
            complete: function () {
                $carrierSelect.prop('disabled', false).trigger('change');
            }
        });
    });

    // Handle Carrier Change
    $(document.body).on('change', 'select[name*="woocommerce_paxy_shipping_carrier"]', function () {
        var $carrierSelect = $(this);
        var $countrySelect = findNextField($carrierSelect, 'woocommerce_paxy_shipping_country');
        var $typeSelect = findNextField($carrierSelect, 'woocommerce_paxy_shipping_package_type');

        var countryId = $countrySelect.val();
        var carrierId = $carrierSelect.val();

        if (!countryId) {
            $typeSelect.empty().append('<option value="">' + paxy_admin_i18n.select_country_first + '</option>');
            return;
        }
        if (!carrierId) {
            $typeSelect.empty().append('<option value="">' + paxy_admin_i18n.select_carrier_first + '</option>');
            return;
        }

        $typeSelect.prop('disabled', true).empty().append('<option value="">' + paxy_admin_i18n.loading_types + '</option>');

        $.ajax({
            url: paxy_admin.ajax_url,
            type: 'GET',
            data: {
                action: 'px_get_dimensions',
                country_id: countryId,
                carrier_id: carrierId,
                nonce: paxy_admin.nonce
            },
            success: function (response) {
                if (response.success) {
                    $typeSelect.empty().append('<option value="">' + paxy_admin_i18n.select_type + '</option>');
                    $.each(response.data, function (index, package) {
                        $typeSelect.append('<option value="' + package.id + '">' + package.label + '</option>');
                    });
                } else {
                    $typeSelect.empty().append('<option value="">' + response.data + '</option>');
                }
            },
            error: function () {
                $typeSelect.empty().append('<option value="">Error loading types</option>');
            },
            complete: function () {
                $typeSelect.prop('disabled', false).trigger('change');
            }
        });
    });

    function findValidationMessage(name) {
        switch (name) {
            case 'paxy_quantity': return paxy_admin_i18n.weight_required;
            default: return name + ' ' + paxy_admin_i18n.required;
        }
    }

    // Handle Label Form Submission
    $(document.body).on('click', '#paxy-create-parcel', function (e) {
        e.preventDefault();

        var $submitButton = $(this);
        var data = {};
        var valid = true;
        $(this).closest('.paxy-pickup-point-form').find('input, select, textarea').each(function () {
            var value = $(this).val();
            if ($(this).is('[required]') && !value) {
                alert(findValidationMessage(this.name));
                valid = false;
            }
            data[this.name] = this.value;
        });

        if (!valid) {
            return;
        }

        $submitButton.prop('disabled', true);

        $.ajax({
            url: paxy_admin.ajax_url + '?action=' + data.action + '&nonce=' + paxy_admin.nonce,
            type: 'POST',
            data: data,
            success: function (response) {
                console.log('AJAX Response:', response);
                if (response.success) {
                    alert(paxy_admin_i18n.parcel_generate_success);
                    window.location.reload();
                } else {
                    alert(paxy_admin_i18n.generic_error + ': ' + response.data);
                }
            },
            error: function (xhr, status, error) {
                console.error('AJAX Error:', error);
                alert(paxy_admin_i18n.parcel_generate_error);
            },
            complete: function () {
                $submitButton.prop('disabled', false);
            }
        });
    });

    $(document.body).on('click', '#paxy-download-label', function (e) {
        e.preventDefault();
        var orderId = $(this).data('order-id');
        window.location.href = paxy_admin.ajax_url + '?action=px_download_label&order_id=' + orderId + '&nonce=' + paxy_admin.nonce;
    });
});
