define([
    'jquery',
    'mage/translate',
    'ko',
    'uiComponent',
    'Magento_Checkout/js/action/set-shipping-information',
    'Magento_Checkout/js/model/shipping-service',
    'Magento_Checkout/js/model/quote',
], function ($, $t, ko, Component, setShippingInformationAction, shippingService, quote) {
    'use strict';

    var isCl = false;
    var isClPoint = false;

    return Component.extend({
        initialize: function () {
            this._super();
            this.container = undefined;

            var self = this;

            var widgetEl = document.createElement('paxy-widget');
            document.body.appendChild(widgetEl);

            if (window.hasOwnProperty('paxyWidget')) {
                window.dispatchEvent(new CustomEvent('paxyWidgetBootstrap'));
            }

            window.addEventListener('paxyWidgetInitialized', function (e) {});

            window.addEventListener('paxyWidgetPointSelected', function (e) {
                self.updateShippingDetails(e.detail);
                self.closePointsModal();
            });

            this.bindEvents();

            return this;
        },
        createUI: function (data) {
            this.destroyUI();

            var self = this;

            var inputHandler = document.querySelector('#checkout-step-shipping_method input[value="' + [data.carrier_code, data.method_code].join('_') + '"]')
            if (inputHandler) {
                var parentContainer = inputHandler.closest('tr');
                if (parentContainer) {
                    var container = document.createElement('tr');
                    container.classList.add('cl-pickup-point-container', 'point-method', '-selected')
                    container.setAttribute('data-carrier-code', data.carrier_code)
                    container.innerHTML = `
                        <td class="col-point" colspan="6">
                            <div class='cl-pickup-point'>
                                <p class="cl-title">${$t('Pickup point:')}</p>
                                <p class="cl-info">-</p>
                                <button type="button" class="button action primary cl-select">${$t('Select')}</button>
                                <input type="hidden" name="cl_pickup_point" class="cl-input" />
                            </div>
                        </td>
                    `;
                    parentContainer.after(container);
                    this.container = container;

                    this.container.querySelector('.cl-select').addEventListener('click', function () {
                        self.openPointsModal();
                        self.updateShippingDetails();
                    });

                }
            }
        },
        destroyUI: function () {
            if (this.container) {
                this.container.remove();
            }
        },
        getWidgetLanguage: function () {
            var browserLanguage = (window.navigator.language || '').split('-').shift().toLowerCase();
            var countryCode = this.languageToCountryCode(browserLanguage);
            var allowedLanguage = ["en", "pl", "hu", "sk", "ro", "cz", "bg", "hr", "lv", "ee", "lt", "de", "it", "se", "dk", "fi"];
            if (allowedLanguage.indexOf(countryCode) > -1) {
                return countryCode;
            }
            return 'pl';
        },
        languageToCountryCode: function(language) {
            switch (language) {
                case 'cs': return 'cz';
                case 'da': return 'dk';
                case 'et': return 'ee';
                case 'sv': return 'se';
                default: return language;
            }
        },
        updateWidgetConfig: function (couriers) {
            window.paxyWidget.setWidgetConfig({
                apiUrl: "https://iai-bridge.paxy.pl/api/v1",
                componentType: "modal",
                couriers: couriers,
                language: this.getWidgetLanguage(),
                token: "0915bec4fd0f2c7ab3ea8e50a7c355a9b4692a84f0ff638d4af6e79cce8a",
                showCouriersSelectInput: couriers.length > 1,
                assetsPathPrefix: requirejs.s.contexts._.config.baseUrl + 'Vendor_CzechlogisticIntegration/'
            });
        },
        updateShippingDetails: function (pointData) {
            if (pointData) {
                localStorage.setItem('clSelectedPickupPoint', JSON.stringify(pointData));
                if (this.container) {
                    this.getPickupPointInput().value = pointData.id;
                    this.getPickupPointInfo().innerHTML = [pointData.name, pointData.address, pointData.city, pointData.postCode].join(', ');
                }
                setShippingInformationAction();
            } else {
                localStorage.removeItem('clSelectedPickupPoint');
                if (this.container) {
                    this.getPickupPointInput().value = undefined;
                    this.getPickupPointInfo().innerHTML = '-';
                }
            }

            if (isCl && isClPoint && !pointData) {
                $('[data-role="opc-continue"]').attr('disabled', true);
            } else {
                $('[data-role="opc-continue"]').removeAttr('disabled');
            }
        },
        openPointsModal: function () {
            window.dispatchEvent(new CustomEvent('paxyWidgetOpen'));
        },
        closePointsModal: function () {
            window.dispatchEvent(new CustomEvent('paxyWidgetClose'));
        },
        getPickupPointInput: function() {
            if (!this.container) {
                return null;
            }

            return this.container.querySelector('.cl-input');
        },
        getPickupPointInfo: function() {
            if (!this.container) {
                return null;
            }

            return this.container.querySelector('.cl-info');
        },
        bindEvents: function() {
            var self = this;

            var handleShippingUpdate = function(e, data) {
                isCl = false;
                if (data !== undefined && data.carrier_code !== undefined && data.carrier_code.includes("czechlogistic")) {
                    isCl = true;
                }
                isClPoint = false;

                if (isCl) {
                    // duplicated event detected
                    if (self.isUpdateInProgress === data.carrier_code || self.lastSelectedCarrierCode === data.carrier_code) {
                        return ;
                    }
                    self.isUpdateInProgress = self.lastSelectedCarrierCode = data.carrier_code;
                    self.updateWidgetConfig([data.carrierCode])

                    $.ajax({
                        method: 'GET',
                        url: '/czechlogistic/front/fetchpickuppoints',
                        data: {
                            data: data
                        },
                        showLoader: true,
                        success: function(resp) {
                            if (resp.carrierCode && resp.hasPoint === true) {
                                self.createUI(data);

                                isClPoint = true;
                                var selectedPickupPoint = localStorage.getItem('clSelectedPickupPoint') ? JSON.parse(localStorage.getItem('clSelectedPickupPoint')) : undefined;

                                self.updateWidgetConfig([resp.carrierCode])

                                if (!selectedPickupPoint || resp.pickupPoints.findIndex((p) => p.id === selectedPickupPoint.id) === -1) {
                                    if(self.isNotFirstShippingMethodSelect === true) {
                                        self.openPointsModal();
                                    }
                                    self.updateShippingDetails();
                                } else {
                                    self.updateShippingDetails(selectedPickupPoint);
                                }

                                if(self.isNotFirstShippingMethodSelect !== true) {
                                    self.isNotFirstShippingMethodSelect = true
                                }

                                localStorage.setItem('clPickupPoints', JSON.stringify(resp.pickupPoints));
                            }   else {
                                self.destroyUI();
                                self.updateShippingDetails();
                            }
                            self.isUpdateInProgress = null;
                            return true;
                        },
                        error: function(resp) {
                            self.destroyUI();
                            self.updateShippingDetails();
                            console.warn(resp);
                            self.isUpdateInProgress = null;
                            return true;
                        }
                    })
                } else {
                    self.isUpdateInProgress = self.lastSelectedCarrierCode = null;
                    self.isNotFirstShippingMethodSelect = true;
                    self.destroyUI();
                    self.updateShippingDetails();
                }
            };

            shippingService.isLoading.subscribe(function(isLoading) {
                if (isLoading) {
                    return ;
                }
                if (self.lastSelectedCarrierCode) {
                    self.lastSelectedCarrierCode = null;
                    self.isNotFirstShippingMethodSelect = false;
                    // shipping UI was reloaded for some reasons - we have to reload the Pickup point selector UI
                    handleShippingUpdate(null, quote.shippingMethod());
                }
            })

            $(document).on('cl-shipping-method', handleShippingUpdate);
        }
    });
});
