define([
    'jquery',
    'ko',
    'mage/translate',
    'Magento_Checkout/js/model/quote',
], function (
    $,
    ko,
    $translate,
    quote,
) {
    return function (target) {
        return target.extend({
            errorValidationMessage: ko.observable(false),
            validateShippingInformation: function () {
                const self = this;

                let shippingMethodData = quote.shippingMethod();
                if (shippingMethodData) {
                    if (shippingMethodData.carrier_code.includes('czechlogistic')) {
                        // pickup point shipping method detection
                        let pickupPointInput = document.querySelector('.cl-pickup-point-container[data-carrier-code="' + shippingMethodData.carrier_code + '"] input[name="cl_pickup_point"]');
                        if (pickupPointInput && (pickupPointInput.value === '' || pickupPointInput.value === 'undefined')) {
                            self.errorValidationMessage(
                                $translate('Please select a pickup point')
                            );
                            return false;
                        }
                    }
                }


                return this._super();
            },
        });
    }
});
