define([
    'jquery',
    'mage/utils/wrapper',
    'Magento_Checkout/js/model/quote'
], function ($, wrapper, quote) {
    'use strict';

    return function (setShippingInformationAction) {

        return wrapper.wrap(setShippingInformationAction, function (originalAction) {
            var shippingAddress = quote.shippingAddress();

            if (shippingAddress['extension_attributes'] === undefined) {
                shippingAddress['extension_attributes'] = {};
            }

            var inputHandler = document.querySelector('.cl-pickup-point .cl-input');
            var pickupPointId = inputHandler ? inputHandler.value : undefined;
            shippingAddress['extension_attributes']['cl_pickup_point'] = pickupPointId;

            var points = JSON.parse(localStorage.getItem('clPickupPoints'));
            if (points !== undefined && points !== null && points.length > 0) {
                points.map(function(point) {
                    if (point.id === pickupPointId) {
                        shippingAddress['extension_attributes']['cl_pickup_point_address'] = point.address;
                        shippingAddress['extension_attributes']['cl_pickup_point_postcode'] = point.postcode;
                        shippingAddress['extension_attributes']['cl_pickup_point_city'] = point.city;
                    }
                })
            }

            // pass execution to original action ('Magento_Checkout/js/action/set-shipping-information')
            return originalAction();
        });
    };
});
