require([
    'jquery'
], function ($) {
    'use strict';
// todo bug when only one cannot select
    function loadCountries() {
        $.ajax({
            url: window.clCountriesUrl,
            data: {
                form_key: window.FORM_KEY
            },
            success: function (resp) {
                $('#carriers_customshipping_cl_country').html('');
                $('#carriers_customshipping_cl_carrier').html('');
                $('#carriers_customshipping_cl_parcel_type').html('');

                resp.countries.map(function(country) {
                    $('#carriers_customshipping_cl_country').append('<option value="'+country.id+'">'+country.name+'</option>')
                });
            },
            error: function (resp) {
                console.warn(resp);
            }
        });
    }

    function loadCarriers(countryId, element) {
        $.ajax({
            url: window.clCarriersUrl + '?countryId='+countryId,
            data: {
                form_key: window.FORM_KEY
            },
            success: function (resp) {
                element.closest('tbody').find('.cl-carrier').html('')
                element.closest('tbody').find('.cl-parcel-type').html('')

                resp.carriers.map(function(carrier) {
                    element.closest('tbody').find('.cl-carrier').append('<option value="'+carrier.id+'">'+carrier.name+'</option>')
                });

                if (resp.carriers.length > 0) {
                    loadParcelTypes(element.closest('tbody').find('.cl-country').val(), resp.carriers[0].id, element);
                }
            },
            error: function (resp) {
                console.warn(resp);
            }
        });
    }

    function loadParcelTypes(countryId, carrierId, element) {
        $.ajax({
            url: window.clParcelTypesUrl + '?countryId='+countryId+'&carrierId='+carrierId,
            data: {
                form_key: window.FORM_KEY
            },
            success: function (resp) {
                element.closest('tbody').find('.cl-parcel-type').html('');
                resp.parceltypes.map(function(parcelType) {
                    element.closest('tbody').find('.cl-parcel-type').append('<option value="'+parcelType.id+'">'+parcelType.name+'</option>')
                });
            },
            error: function (resp) {
                console.warn(resp);
            }
        });
    }

    $(document).ready(function() {
        // loadCountries();

        $('.cl-country').on('change', function() {
            loadCarriers($(this).val(), $(this));
        })

        $('.cl-carrier').on('change', function() {
            var clCountry = $(this).closest('tbody').find('.cl-country').val();
            loadParcelTypes(clCountry, $(this).val(), $(this));
        })
    });

});

