<?php


namespace Vendor\CzechlogisticIntegration\Setup;


use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;

class UpgradeSchema implements UpgradeSchemaInterface
{
    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    public function upgrade(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
            // todo check if tables exist
            $installer = $setup;
            $installer->startSetup();

            if ($installer->getConnection()->tableColumnExists('quote', 'cl_pickup_point') === false) {
                $installer->getConnection()->addColumn(
                    $installer->getTable('quote'),
                    'cl_pickup_point',
                    [
                        'type' => 'text',
                        'size' => 255,
                        'nullable' => true,
                        'comment' => 'cl pickup point',
                    ]
                );
            }

            if ($installer->getConnection()->tableColumnExists('sales_order_grid', 'cl_pickup_point') === false) {
                $installer->getConnection()->addColumn(
                    $installer->getTable('sales_order_grid'),
                    'cl_pickup_point',
                    [
                        'type' => 'text',
                        'size' => 255,
                        'nullable' => true,
                        'comment' => 'cl pickup point',
                    ]
                );
            }


        if ($installer->getConnection()->tableColumnExists('czechlogistic_orders', 'czechlogistic_pickup_point_address') === false) {
            $installer->getConnection()->addColumn(
                $installer->getTable('czechlogistic_orders'),
                'czechlogistic_pickup_point_address',
                [
                    'type' => 'text',
                    'size' => 255,
                    'nullable' => true,
                    'comment' => 'cl pickup point address',
                ]
            );
        }

        if ($installer->getConnection()->tableColumnExists('czechlogistic_orders', 'czechlogistic_pickup_point_postcode') === false) {
            $installer->getConnection()->addColumn(
                $installer->getTable('czechlogistic_orders'),
                'czechlogistic_pickup_point_postcode',
                [
                    'type' => 'text',
                    'size' => 255,
                    'nullable' => true,
                    'comment' => 'cl pickup point address',
                ]
            );
        }

        if ($installer->getConnection()->tableColumnExists('czechlogistic_orders', 'czechlogistic_pickup_point_city') === false) {
            $installer->getConnection()->addColumn(
                $installer->getTable('czechlogistic_orders'),
                'czechlogistic_pickup_point_city',
                [
                    'type' => 'text',
                    'size' => 255,
                    'nullable' => true,
                    'comment' => 'cl pickup point address',
                ]
            );
        }

        if ($installer->getConnection()->tableColumnExists('quote', 'cl_pickup_point_address') === false) {
            $installer->getConnection()->addColumn(
                $installer->getTable('quote'),
                'cl_pickup_point_address',
                [
                    'type' => 'text',
                    'size' => 255,
                    'nullable' => true,
                    'comment' => 'cl pickup point address',
                ]
            );
        }

        if ($installer->getConnection()->tableColumnExists('quote', 'cl_pickup_point_postcode') === false) {
            $installer->getConnection()->addColumn(
                $installer->getTable('quote'),
                'cl_pickup_point_postcode',
                [
                    'type' => 'text',
                    'size' => 255,
                    'nullable' => true,
                    'comment' => 'cl pickup point postcode',
                ]
            );
        }

        if ($installer->getConnection()->tableColumnExists('quote', 'cl_pickup_point_city') === false) {
            $installer->getConnection()->addColumn(
                $installer->getTable('quote'),
                'cl_pickup_point_city',
                [
                    'type' => 'text',
                    'size' => 255,
                    'nullable' => true,
                    'comment' => 'cl pickup point city',
                ]
            );
        }


        $installer->endSetup();

    }
}
