<?php


namespace Vendor\CzechlogisticIntegration\Setup;


use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;

class InstallSchema implements InstallSchemaInterface
{
    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;
        $installer->startSetup();

        if ($installer->getConnection()->tableColumnExists('quote', 'cl_pickup_point') === false) {
            $installer->getConnection()->addColumn(
                $installer->getTable('quote'),
                'cl_pickup_point',
                [
                    'type' => 'text',
                    'size' => 255,
                    'nullable' => true,
                    'comment' => 'cl pickup point',
                ]
            );
        }

        if ($installer->getConnection()->tableColumnExists('quote', 'cl_pickup_point_address') === false) {
            $installer->getConnection()->addColumn(
                $installer->getTable('quote'),
                'cl_pickup_point_address',
                [
                    'type' => 'text',
                    'size' => 255,
                    'nullable' => true,
                    'comment' => 'cl pickup point address',
                ]
            );
        }

        if ($installer->getConnection()->tableColumnExists('quote', 'cl_pickup_point_postcode') === false) {
            $installer->getConnection()->addColumn(
                $installer->getTable('quote'),
                'cl_pickup_point_postcode',
                [
                    'type' => 'text',
                    'size' => 255,
                    'nullable' => true,
                    'comment' => 'cl pickup point postcode',
                ]
            );
        }

        if ($installer->getConnection()->tableColumnExists('quote', 'cl_pickup_point_city') === false) {
            $installer->getConnection()->addColumn(
                $installer->getTable('quote'),
                'cl_pickup_point_city',
                [
                    'type' => 'text',
                    'size' => 255,
                    'nullable' => true,
                    'comment' => 'cl pickup point city',
                ]
            );
        }


        if ($installer->getConnection()->tableColumnExists('sales_order', 'cl_pickup_point') === false) {
            $installer->getConnection()->addColumn(
                $installer->getTable('sales_order'),
                'cl_pickup_point',
                [
                    'type' => 'text',
                    'size' => 255,
                    'nullable' => true,
                    'comment' => 'cl pickup point',
                ]
            );
        }


        if ($installer->getConnection()->tableColumnExists('sales_order_grid', 'cl_pickup_point') === false) {
            $installer->getConnection()->addColumn(
                $installer->getTable('sales_order_grid'),
                'cl_pickup_point',
                [
                    'type' => 'text',
                    'size' => 255,
                    'nullable' => true,
                    'comment' => 'cl pickup point',
                ]
            );
        }


        $tableName = $installer->getTable('czechlogistic_orders');

        /**
         * Create table 'czechlogistic_orders'
         */
        if ($installer->getConnection()->isTableExists($tableName) != true) {
            $table = $installer->getConnection()
                ->newTable($tableName)
                ->addColumn(
                    'order_id',
                    \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                    null,
                    ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                    'order ID'
                )
                ->addColumn(
                    'czechlogistic_country_id',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    255,
                    ['nullable' => false, 'default' => null],
                    'Parcel number'
                )
                ->addColumn(
                    'czechlogistic_carrier_id',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    255,
                    ['nullable' => false, 'default' => null],
                    'Parcel created at'
                )
                ->addColumn(
                    'czechlogistic_parcel_id',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    255,
                    ['nullable' => false, 'default' => null],
                    'Parcel should regain at'
                )
                ->addColumn(
                    'czechlogistic_pickup_point_address',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    255,
                    ['nullable' => false, 'default' => null],
                    'picku point address'
                )
                ->addColumn(
                    'czechlogistic_pickup_point_postcode',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    255,
                    ['nullable' => false, 'default' => null],
                    'picku point address'
                )
                ->addColumn(
                    'czechlogistic_pickup_point_city',
                    \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    255,
                    ['nullable' => false, 'default' => null],
                    'pickup point address'
                )
                ->setOption('type', 'InnoDB')
                ->setOption('charset', 'utf8');

            $installer->getConnection()->createTable($table);
        }

        $installer->endSetup();
    }
}
