<?php


namespace Vendor\CzechlogisticIntegration\Sale\Observer;


use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\ObjectManagerInterface;
use Magento\Quote\Model\QuoteFactory;
use Vendor\CzechlogisticIntegration\Model\CzechlogisticOrder;

class OrderPlaceAfter implements ObserverInterface
{
    protected $_logger;
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;
    /**
     * @var QuoteFactory
     */
    private $quoteFactory;

    /**
     * @param \Psr\Log\LoggerInterface $_logger
     */

    public function __construct(
        \Psr\Log\LoggerInterface $_logger,
        ScopeConfigInterface $scopeConfig,
        ObjectManagerInterface $objectManager,
        QuoteFactory $quoteFactory
    )
    {
        $this->_logger = $_logger;
        $this->scopeConfig = $scopeConfig;
        $this->objectManager = $objectManager;
        $this->quoteFactory = $quoteFactory;
    }


    public function execute(Observer $observer)
    {
        $order = $observer->getEvent()->getOrder();

        $quote = $this->quoteFactory->create()->load($order->getQuoteId());
        if ($quote->getClPickupPoint()) {
            $order->setClPickupPoint($quote->getClPickupPoint());
            $order->save();
        }

        $method = explode('_', $order->getShippingMethod());
        $isCzechlogisticCarrier = false;

        if (count($method) > 1) {
            $method = $method[0];
            if (strpos($method, 'czechlogistic') !== false) {
                $isCzechlogisticCarrier = true;
            }
        }

        if ($isCzechlogisticCarrier) {
            $countryId = $this->scopeConfig->getValue('carriers/' . $method . '/cl_country', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
            $carrierId = $this->scopeConfig->getValue('carriers/' . $method . '/cl_carrier', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
            $parcelTypeId = $this->scopeConfig->getValue('carriers/' . $method . '/cl_parcel_type', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

            $obj = $this->objectManager->create(CzechlogisticOrder::class);
            $obj->setOrderId($order->getId());
            $obj->setCzechlogisticCountryId($countryId);
            $obj->setCzechlogisticCarrierId($carrierId);
            $obj->setCzechlogisticParcelId($parcelTypeId);

            if (!empty($quote->getClPickupPointCity())) {
                $obj->setCzechlogisticPickupPointCity($quote->getClPickupPointCity());
            }

            if (!empty($quote->getClPickupPointPostcode())) {
                $obj->setCzechlogisticPickupPointPostcode($quote->getClPickupPointPostcode());
            }

            if (!empty($quote->getClPickupPointAddress())) {
                $obj->setCzechlogisticPickupPointAddress($quote->getClPickupPointAddress());
            }

            $obj->save();
        }

    }
}
