<?php


namespace Vendor\CzechlogisticIntegration\Plugin;


class ShippingAddressManagement {
    protected $quoteRepository;

    public function __construct(
        \Magento\Quote\Model\QuoteRepository $quoteRepository
    ) {
        $this->quoteRepository = $quoteRepository;
    }

    /**
     * @param \Magento\Checkout\Model\ShippingInformationManagement $subject
     * @param $cartId
     * @param \Magento\Checkout\Api\Data\ShippingInformationInterface $addressInformation
     */
    public function beforeSaveAddressInformation(
        \Magento\Checkout\Model\ShippingInformationManagement $subject,
        $cartId,
        \Magento\Checkout\Api\Data\ShippingInformationInterface $addressInformation
    ) {
        $extAttributes = $addressInformation->getShippingAddress()->getExtensionAttributes();
        $point = $extAttributes->getClPickupPoint();
        $pointAddress = $extAttributes->getClPickupPointAddress();
        $pointPostcode = $extAttributes->getClPickupPointPostcode();
        $pointCity = $extAttributes->getClPickupPointCity();
        $quote = $this->quoteRepository->getActive($cartId);
        $quote->setClPickupPoint($point);
        $quote->setClPickupPointCity($pointCity);
        $quote->setClPickupPointAddress($pointAddress);
        $quote->setClPickupPointPostcode($pointPostcode);
    }
}
