<?php

namespace Vendor\CzechlogisticIntegration\Plugin;

use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\OrderRepositoryInterface;

class OrderPlugin
{
  public function afterGet(\Magento\Sales\Model\OrderRepository\Interceptor $interceptor, OrderInterface $order)
  {
    $this->addClPickupPoint($order);
    return $order;
  }

  public function afterGetList(OrderRepositoryInterface $subject, $searchResult)
  {
    foreach ($searchResult->getItems() as $order) {
      if ($order instanceof OrderInterface) {
        $this->addClPickupPoint($order);
      }
    }
    return $searchResult;
  }
  private function addClPickupPoint($order)
  {
    $model = $order->getExtensionAttributes();
    if ($model === null) {
      $model = $this->extensionFactory->create();
    }
    $model->setClPickupPoint($order->getData('cl_pickup_point'));
    $order->setExtensionAttributes($model);
  }

  protected $extensionFactory;

  public function __construct(
    \Magento\Sales\Api\Data\OrderExtensionFactory $extensionFactory
  ) {

    $this->extensionFactory = $extensionFactory;
  }

}
