<?php


namespace Vendor\CzechlogisticIntegration\Model;


use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Data\OptionSourceInterface;

class CzechlogisticCountry implements OptionSourceInterface
{
    private $czechApiUrl = 'https://api.czechlogistic.pl';
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * CzechlogisticCountry constructor.
     * @param string $czechApiUrl
     */
    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    public function toOptionArray()
    {
        $countries = $this->loadCountries();
        $options = [];

        foreach ($countries as $country) {
            $options[] = [
                'label' => $country['name'],
                'value' => $country['id'],
            ];
        }
        return $options;
    }

    private function loadCountries()
    {
        $apiKey = $this->scopeConfig->getValue('czechlogistic_config/general/apiKey', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $apiSecret = $this->scopeConfig->getValue('czechlogistic_config/general/apiSecret', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $ch = curl_init($this->czechApiUrl . "/country/");
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "CL-API-KEY: $apiKey",
            "CL-API-TOKEN: $apiSecret",
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $apiResponse = curl_exec($ch);
        curl_close($ch);
        if ($apiResponse) {
            $response = json_decode($apiResponse, true);
            return $response['countries'];
        }

        return [];
    }
}
