<?php


namespace Vendor\CzechlogisticIntegration\Model;


use Magento\Framework\App\Config\ScopeConfigInterface;

abstract class AbstractCzechlogisticParcelType
{
    private $czechApiUrl = 'https://api.czechlogistic.pl';
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * CzechlogisticCountry constructor.
     * @param string $czechApiUrl
     */
    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    public function toOptionArray()
    {
        $parcelTypes = $this->loadParcelTypes();
        $options = [];

        foreach ($parcelTypes as $parcelType) {
            $options[] = [
                'label' => $parcelType['name'],
                'value' => $parcelType['id'],
            ];
        }
        return $options;
    }

    private function loadParcelTypes()
    {
        $apiKey = $this->scopeConfig->getValue('czechlogistic_config/general/apiKey', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $apiSecret = $this->scopeConfig->getValue('czechlogistic_config/general/apiSecret', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $countryId = $this->scopeConfig->getValue('carriers/'.$this->groupId.'/cl_country', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $carrierId = $this->scopeConfig->getValue('carriers/'.$this->groupId.'/cl_carrier', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

        $ch = curl_init();
        $endpoint = $this->czechApiUrl . '/dimension/';
        $params = array(
            'countryId' => $countryId,
            'carrierId' => $carrierId,
        );
        $url = $endpoint . '?' . http_build_query($params);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "CL-API-KEY: $apiKey",
            "CL-API-TOKEN: $apiSecret",
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $apiResponse = curl_exec($ch);
        curl_close($ch);
        if ($apiResponse) {
            $result = json_decode($apiResponse,true);
            $ret = [];
            foreach ($result['categories'] as $r) {
                $ret[] = [
                    'id' => $r['id'],
                    'name' => $r['label']
                ];
            }
            return $ret;
        }

        return [];
    }
}
