<?php


namespace Vendor\CzechlogisticIntegration\Model;


use Magento\Framework\App\Config\ScopeConfigInterface;

abstract class AbstractCzechlogisticCarrier
{
    private $czechApiUrl = 'https://api.czechlogistic.pl';
    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * CzechlogisticCountry constructor.
     * @param string $czechApiUrl
     */
    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    public function toOptionArray()
    {
        $carriers = $this->loadCarriers();
        $options = [];

        foreach ($carriers as $carrier) {
            $options[] = [
                'label' => $carrier['name'],
                'value' => $carrier['id'],
            ];
        }
        return $options;
    }

    private function loadCarriers()
    {
        $apiKey = $this->scopeConfig->getValue('czechlogistic_config/general/apiKey', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $apiSecret = $this->scopeConfig->getValue('czechlogistic_config/general/apiSecret', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $countryId = $this->scopeConfig->getValue('carriers/'.$this->groupId.'/cl_country', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

        if (!$countryId) {
            return [];
        }

        $ch = curl_init();
        $endpoint = $this->czechApiUrl . '/carrier/country/'.$countryId;
        $params = array(
            'countryId' => $countryId
        );
        $url = $endpoint . '?' . http_build_query($params);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "CL-API-KEY: $apiKey",
            "CL-API-TOKEN: $apiSecret",
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $apiResponse = curl_exec($ch);
        curl_close($ch);
        if ($apiResponse) {
            $response = json_decode($apiResponse, true);
            return $response['carriers'];
        }
        return [];
    }
}
