<?php


namespace Vendor\CzechlogisticIntegration\Controller\front;

class FetchPickupPoints extends \Magento\Framework\App\Action\Action
{
    protected $_pageFactory;
    /**
     * @var \Magento\Framework\Controller\Result\JsonFactory
     */
    private $jsonResultFactory;
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    private $scopeConfig;

    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $pageFactory,
        \Magento\Framework\Controller\Result\JsonFactory $jsonResultFactory,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig)
    {
        $this->_pageFactory = $pageFactory;
        parent::__construct($context);
        $this->jsonResultFactory = $jsonResultFactory;
        $this->scopeConfig = $scopeConfig;
    }

    public function execute()
    {
        $data = $this->_request->getParam('data');

        $carrierCode = $data['carrier_code'];

        $pickupPoint = $this->scopeConfig->getValue('carriers/'.$carrierCode.'/cl_pickup_point', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

        if (!empty($pickupPoint)) {
            $pickupPoints = $this->fetchPickupPoints($pickupPoint);
            // todo fetch points and return
            $data = ['hasPoint' => true, 'carrierCode' => $pickupPoint, 'pickupPoints' => $pickupPoints];
        }   else {
            $data = ['hasPoint' => false];
        }

        $result = $this->jsonResultFactory->create();
        $result->setData($data);
        return $result;
    }

    private function fetchPickupPoints($pickupPoint)
    {
        $url = "https://iai-bridge.czechlogistic.pl/api/v1/pickupPoints/".$pickupPoint;
        $file = file_get_contents($url);
        $xml = simplexml_load_string($file);
        $ret = [];

        foreach ($xml->pickup_point as $point) {
            $item = [
                'id' => (string) $point->id,
                'address' => (string) $point->address,
                'postcode' => (string) $point->postcode,
                'city' => (string) $point->city,
                'lat' => (string) $point->latitude,
                'lng' => (string) $point->longitude
            ];

            $ret[] = $item;
        }

        return $ret;
    }


}
