<?php


namespace Vendor\CzechlogisticIntegration\Controller\Adminhtml\Order;

use Magento\Backend\App\Action;
use Magento\Framework\ObjectManager\ObjectManager;
use Magento\Sales\Api\OrderManagementInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Psr\Log\LoggerInterface;
use Vendor\CzechlogisticIntegration\Model\CzechlogisticOrder;

class CustomTab extends \Magento\Sales\Controller\Adminhtml\Order
{
    private $czechApiUrl = 'https://api.czechlogistic.pl';

    /**
     * @var \Magento\Framework\View\LayoutFactory
     */
    protected $layoutFactory;
    private $scopeConfig;
    private $urlBuilder;
    private $formKey;

    /**
     * @param Action\Context $context
     * @param \Magento\Framework\Registry $coreRegistry
     * @param \Magento\Framework\App\Response\Http\FileFactory $fileFactory
     * @param \Magento\Framework\Translate\InlineInterface $translateInline
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     * @param \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory
     * @param \Magento\Framework\View\Result\LayoutFactory $resultLayoutFactory
     * @param \Magento\Framework\Controller\Result\RawFactory $resultRawFactory
     * @param OrderManagementInterface $orderManagement
     * @param OrderRepositoryInterface $orderRepository
     * @param LoggerInterface $logger
     * @param \Magento\Framework\View\LayoutFactory $layoutFactory
     *
     * @SuppressWarnings(PHPMD.ExcessiveParameterList)
     * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
     */
    public function __construct(
        Action\Context $context,
        \Magento\Framework\Registry $coreRegistry,
        \Magento\Framework\App\Response\Http\FileFactory $fileFactory,
        \Magento\Framework\Translate\InlineInterface $translateInline,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory,
        \Magento\Framework\View\Result\LayoutFactory $resultLayoutFactory,
        \Magento\Framework\Controller\Result\RawFactory $resultRawFactory,
        OrderManagementInterface $orderManagement,
        OrderRepositoryInterface $orderRepository,
        LoggerInterface $logger,
        \Magento\Framework\View\LayoutFactory $layoutFactory,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\UrlInterface $urlBuilder,
        \Magento\Framework\Data\Form\FormKey $formKey
    ) {
        $this->layoutFactory = $layoutFactory;
        parent::__construct(
            $context,
            $coreRegistry,
            $fileFactory,
            $translateInline,
            $resultPageFactory,
            $resultJsonFactory,
            $resultLayoutFactory,
            $resultRawFactory,
            $orderManagement,
            $orderRepository,
            $logger
        );
        $this->scopeConfig = $scopeConfig;
        $this->urlBuilder = $urlBuilder;
        $this->formKey = $formKey;
    }

    /**
     * Generate order history for ajax request
     *
     * @return \Magento\Framework\Controller\Result\Raw
     */
    public function execute()
    {
        $this->_initOrder();
        $layout = $this->layoutFactory->create();
        $order = $this->orderRepository->get($this->_coreRegistry->registry('current_order')->getId());

        $method = explode('_', $order->getShippingMethod());
        $isCzechlogisticCarrier = false;

        if (count($method) > 1) {
            $method = $method[0];
            if (strpos($method, 'czechlogistic') !== false) {
                $isCzechlogisticCarrier = true;
            }
        }

        $block = $layout->createBlock('Vendor\CzechlogisticIntegration\Block\Adminhtml\Order\View\Tab\CzechlogisticTransportTab');

        if ($isCzechlogisticCarrier) {
            if ($order->getCzechlogisticShouldRegainNumber()) {
                $date = \DateTime::createFromFormat('Y-m-d H:i:s', $order->getCzechlogisticShouldRegainNumber());
                $now = new \DateTime();
                $diff =  $now->getTimestamp() - $date->getTimestamp();
                if ($diff > 20) {
                    $data = $this->getCzechlogisticParcelStatus($order->getCzechlogisticParcelNumber(), true)[0];
                    $order->setCzechlogisticParcelNumber($data['trackingNr']);
                    $order->setCzechlogisticShouldRegainNumber(null);
                    $order->save();
                }
            }

            if ($order->getCzechlogisticParcelNumber()) {
                $block->setData('status', $this->getCzechlogisticParcelStatus($order->getCzechlogisticParcelNumber()));
                $block->setData('downloadParcelUrl', $this->urlBuilder->getRouteUrl('customshipping/czechlogistic/downloadlabel', ['parcelNumber' => $order->getCzechlogisticParcelNumber()]));

            }
            $block->setData('isCzechlogisticCarrier', $isCzechlogisticCarrier);
            $block->setData('generateParcelUrl', $this->urlBuilder->getRouteUrl('customshipping/czechlogistic/generateparcel'));
        }

        $html = $block->toHtml();
        $this->_translateInline->processResponseBody($html);
        /** @var \Magento\Framework\Controller\Result\Raw $resultRaw */
        $resultRaw = $this->resultRawFactory->create();
        $resultRaw->setContents($html);
        return $resultRaw;
    }

    public function getFormKey()
    {
        return $this->formKey->getFormKey();
    }

    private function getCzechlogisticParcelStatus($czechlogistic_parcel_number, $returnAll = false)
    {
        $apiKey = $this->scopeConfig->getValue('czechlogistic_config/general/apiKey', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $apiSecret = $this->scopeConfig->getValue('czechlogistic_config/general/apiSecret', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

        $ch = curl_init();
        $endpoint = $this->czechApiUrl . '/przesylki/statusy';
        $params = array(
            'trackingNrs' => [
                $czechlogistic_parcel_number
            ]
        );
        $url = $endpoint . '?' . http_build_query($params);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "CL-API-KEY: $apiKey",
            "CL-API-TOKEN: $apiSecret",
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_AUTOREFERER, true);
        $result = curl_exec($ch);
        $result = json_decode($result, true);
        if ($returnAll) {
            return $result;
        }
        if (isset($result[0]['label'])) {
            return $result[0]['label'];
        }

        return 'Brak';
    }
}
