<?php


namespace Vendor\CzechlogisticIntegration\Controller\Adminhtml\Czechlogistic;

use Magento\Backend\App\Action\Context;

class Parceltype extends \Magento\Backend\App\Action
{
    private $czechApiUrl = 'https://api.czechlogistic.pl';

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    public function __construct(Context $context, \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig)
    {
        parent::__construct($context);
        $this->scopeConfig = $scopeConfig;
    }

    public function execute()
    {
        $result = $this->resultFactory->create('json');
        $result = $result->setData(['parceltypes' =>  $this->loadParcelTypes()]);
        return $result;
    }


    private function loadParcelTypes()
    {
        $apiKey = $this->scopeConfig->getValue('czechlogistic_config/general/apiKey', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $apiSecret = $this->scopeConfig->getValue('czechlogistic_config/general/apiSecret', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $ch = curl_init();
        $endpoint = $this->czechApiUrl . '/dimension/';
        $params = array(
            'countryId' => $_GET['countryId'],
            'carrierId' => $_GET['carrierId'],
        );
        $url = $endpoint . '?' . http_build_query($params);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "CL-API-KEY: $apiKey",
            "CL-API-TOKEN: $apiSecret",
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $apiResponse = curl_exec($ch);
        curl_close($ch);
        if ($apiResponse) {
            $result = json_decode($apiResponse,true);
            $ret = [];
            foreach ($result['categories'] as $r) {
                $ret[] = [
                    'id' => $r['id'],
                    'name' => $r['label']
                ];
            }
            return $ret;
        }

        return [];
    }
}
