<?php


namespace Vendor\CzechlogisticIntegration\Controller\Adminhtml\Czechlogistic;


use Magento\Backend\App\Action\Context;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Message\ManagerInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Api\OrderManagementInterface;
use Vendor\CzechlogisticIntegration\Model\ResourceModel\CzechlogisticOrder\Collection;

class MultiLabelsDownload extends \Magento\Backend\App\Action
{
    private $czechApiUrl = 'https://api.czechlogistic.pl';

    /**
     * @var OrderManagementInterface
     */
    protected $orderManagement;

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var ManagerInterface
     */
    private $manager;
    /**
     * @var OrderRepositoryInterface
     */
    private $orderRepository;
    /**
     * @var SearchCriteriaBuilder
     */
    private $searchCriteriaBuilder;

    public function __construct(Context $context, \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig, ManagerInterface $manager, OrderRepositoryInterface $orderRepository, SearchCriteriaBuilder $searchCriteriaBuilder)
    {
        parent::__construct($context);
        $this->scopeConfig = $scopeConfig;
        $this->manager = $manager;
        $this->orderRepository = $orderRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }

    public function execute()
    {
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $resultRedirect->setPath($this->_redirect->getRefererUrl());

        $searchCriteria = $this->searchCriteriaBuilder
            ->addFilter('entity_id', $this->_request->getParam('selected'), 'in')->create();
        $orders = $this->orderRepository->getList($searchCriteria)->getItems();
        $parcelNumbers = [];

        $skippedIds = [];
        foreach ($orders as $order) {
            if (empty($order->getCzechlogisticParcelNumber())) {
                $skippedIds[] = $order->getIncrementId();
                continue;
            }

            $parcelNumbers[] = $order->getCzechlogisticParcelNumber();
        }

        if (count($skippedIds) > 0) {
            $this->messageManager->addWarningMessage('Pominięte zamówienia, ze względu na brak numeru paczki: '. implode(', ', $skippedIds));
        }

        if (count($parcelNumbers) > 0) {
            $apiKey = $this->scopeConfig->getValue('czechlogistic_config/general/apiKey', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
            $apiSecret = $this->scopeConfig->getValue('czechlogistic_config/general/apiSecret', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
            $ch = curl_init();
            $endpoint = $this->czechApiUrl . '/etykieta/drukuj';
            $params = array(
                'parcelNumbers' => $parcelNumbers
            );
            $url = $endpoint . '?' . urldecode(http_build_query($params));
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                "CL-API-KEY: $apiKey",
                "CL-API-TOKEN: $apiSecret",
                'Accept: application/json'
            ]);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch, CURLOPT_AUTOREFERER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
            $result = curl_exec($ch);
            $data = json_decode($result, true);
            if (json_last_error() == JSON_ERROR_NONE && !empty($data['message'])) {
                $this->messageManager->addWarningMessage($data['message']);
                return $resultRedirect;
            }

            $probably_binary = (is_string($result) === true && ctype_print($result) === false);

            header('Cache-Control: public');
            header('Content-type: application/pdf');
            header('Content-Disposition: attachment; filename="etykiety.pdf"');
            header('Content-Length: '.strlen($result));
            echo $result;
        }

        return $resultRedirect;
    }
}
