<?php


namespace Vendor\CzechlogisticIntegration\Controller\Adminhtml\Czechlogistic;

use Magento\Backend\App\Action\Context;
use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\ObjectManagerInterface;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\OrderRepository;
use Magento\TestFramework\Eav\Model\Attribute\DataProvider\DateTime;
use Vendor\CzechlogisticIntegration\Model\CzechlogisticOrder;
use Vendor\CzechlogisticIntegration\Model\ResourceModel\CzechlogisticOrder\Collection;

class Generateparcel extends \Magento\Backend\App\Action implements CsrfAwareActionInterface
{
    private $czechApiUrl = 'https://api.czechlogistic.pl';

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var OrderRepository
     */
    private $orderRepository;
    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    public function __construct(Context $context, \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig, OrderRepository $orderRepository, \Magento\Framework\Message\ManagerInterface $messageManager, ObjectManagerInterface $objectManager)
    {
        parent::__construct($context);
        $this->scopeConfig = $scopeConfig;
        $this->orderRepository = $orderRepository;
        $this->messageManager = $messageManager;
    }

    public function execute()
    {
        $result = $this->resultFactory->create('json');
        $result = $result->setData(['carriers' =>  'sadsa']);
        $czechlogisticOrder = $this->_objectManager->create(Collection::class)->addFieldToFilter('order_id', $this->_request->getParam('id_order'));

        if ($czechlogisticOrder === null || $czechlogisticOrder->count() === 0) {
            $this->messageManager->addErrorMessage('Nie udało się utworzyć przesyłki w Czechlogistic (Brak danych dla czechlogistic)');
            $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
            $resultRedirect->setPath($this->_redirect->getRefererUrl());
            return $resultRedirect;
        }

        $czechlogisticOrder = $czechlogisticOrder->getFirstItem();

        $order = $this->orderRepository->get($this->_request->getParam('id_order'));

        $countryId = $czechlogisticOrder->getCzechlogisticCountryId();
        $carrierId = $czechlogisticOrder->getCzechlogisticCarrierId();
        $parcelTypeId = $czechlogisticOrder->getCzechlogisticParcelId();

        $countryDetails = $this->loadCountryDetails($countryId);
        $book = $this->createBook($countryDetails['name']);
        $bookNumber = $book->ksiazka->nr;

        $carrier = $this->loadCarrierDetails($carrierId)['carrier'];
        $carrierCode = $carrier['apiCode'];

        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $resultRedirect->setPath($this->_redirect->getRefererUrl());

        $parcel = $this->createParcel($order, $bookNumber, $parcelTypeId, $carrierCode, $this->_request->getParam('quantity'), $czechlogisticOrder);
        $errorMessage = 'Nie udało się utworzyć przesyłki w Czechlogistic';

        if (isset($parcel->przesylka->nr)) {
            $order->setCzechlogisticParcelNumber($parcel->przesylka->nr);
            $order->setCzechlogisticCreated(new \DateTime());
            $order->save();
            $this->messageManager->addSuccessMessage('Utworzono przesyłkę w Czechlogistic');

            return $resultRedirect;
        } else if (isset($parcel->message)) {
            $errorMessage .= " ($parcel->message)";
        }

        $this->messageManager->addErrorMessage($errorMessage);
        return $resultRedirect;

    }

    public function createCsrfValidationException(RequestInterface $request): ?InvalidRequestException
    {
        return null;
    }

    public function validateForCsrf(RequestInterface $request): ?bool
    {
        return true;
    }

    private function createBook($countryName)
    {
        $apiKey = $this->scopeConfig->getValue('czechlogistic_config/general/apiKey', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $apiSecret = $this->scopeConfig->getValue('czechlogistic_config/general/apiSecret', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

        $ch = curl_init();
        $fields = array( 'kraj' => $countryName);
        $postvars = '';
        foreach($fields as $key=>$value) {
            $postvars .= $key . "=" . $value . "&";
        }
        $url = $this->czechApiUrl . '/ksiazka/utworz';
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "CL-API-KEY: $apiKey",
            "CL-API-TOKEN: $apiSecret"
        ]);
        curl_setopt($ch,CURLOPT_URL,$url);
        curl_setopt($ch,CURLOPT_POST, 1);                //0 for a get request
        curl_setopt($ch,CURLOPT_POSTFIELDS,$postvars);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch,CURLOPT_CONNECTTIMEOUT ,3);
        curl_setopt($ch,CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        $response = curl_exec($ch);

        return json_decode($response);
    }

    private function loadCountryDetails($countryId)
    {
        $apiKey = $this->scopeConfig->getValue('czechlogistic_config/general/apiKey', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $apiSecret = $this->scopeConfig->getValue('czechlogistic_config/general/apiSecret', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

        $ch = curl_init();
        $endpoint = $this->czechApiUrl . '/country/'.$countryId;
        $params = array();
        $url = $endpoint . '?' . http_build_query($params);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "CL-API-KEY: $apiKey",
            "CL-API-TOKEN: $apiSecret",
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $apiResponse = curl_exec($ch);
        curl_close($ch);
        if ($apiResponse) {
            $apiResponse = json_decode($apiResponse,true);
            return $apiResponse['country'];
        }

        return [];
    }

    private function loadCarrierDetails($carrierId)
    {
        $apiKey = $this->scopeConfig->getValue('czechlogistic_config/general/apiKey', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $apiSecret = $this->scopeConfig->getValue('czechlogistic_config/general/apiSecret', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

        $ch = curl_init();
        $endpoint = $this->czechApiUrl . '/carrier/'.$carrierId;
        $params = array();
        $url = $endpoint . '?' . http_build_query($params);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "CL-API-KEY: $apiKey",
            "CL-API-TOKEN: $apiSecret",
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $apiResponse = curl_exec($ch);
        curl_close($ch);
        if ($apiResponse) {
            return json_decode($apiResponse,true);
        }

        return [];
    }

    private function createParcel($order, $bookNumber, $category, $carrierCode, $quantity, $czechlogisticOrder)
    {
        $apiKey = $this->scopeConfig->getValue('czechlogistic_config/general/apiKey', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $apiSecret = $this->scopeConfig->getValue('czechlogistic_config/general/apiSecret', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
        $ch = curl_init();

        $fields = array(
            'nr_ksiazki' => $bookNumber,
            'rodzaj' => $category,
            'kodpocztowy' => $order->getShippingAddress()->getPostcode(),
            'nazwaodbiorcy' => $order->getShippingAddress()->getCompany() . ' ' . $order->getShippingAddress()->getFirstname() . ' ' . $order->getShippingAddress()->getLastname(),
            'ulica' => implode(' ', $order->getShippingAddress()->getStreet()),
            'nrbudynku' => '',
            'miejscowosc' => $order->getShippingAddress()->getCity(),
            'region' => $order->getShippingAddress()->getRegion(),
            'email' => $order->getShippingAddress()->getEmail(),
            'nrtelefonu' => $order->getShippingAddress()->getTelephone(),
            'waga' => round(($order->getWeight()/$quantity), 1),
            'przewoznik' => $carrierCode,
            'doc_wz' => $order->getId(),
            'referencje' => $order->getId(),
            'ilosc' => $quantity
        );

        if (!empty($order->getClPickupPoint())) {
            $pickupPointId = $order->getClPickupPoint();
            $pointParsedData = $this->parsePointId($pickupPointId);
            $pointId = $pointParsedData['body']['id'];
            $pointType = $pointParsedData['body']['pointType'];

            $fields['rodzaj'] = $pointType;
            $fields['point_id'] = $pointId;

            if ($pointType === 'office') {
                $fields['point_id'] = null;
                $fields['office_id'] = $pointId;
            }

            $isNaPostuOrBalik = false;
            if (strpos($order->getClPickupPoint(), 'cp_napostu') !== false) {
                $isNaPostuOrBalik = true;
            }
            if (strpos($order->getClPickupPoint(), 'cp_balikovna') !== false) {
                $isNaPostuOrBalik = true;
            }

            if ($carrierCode === 'kurier poczta') {
                $fields['miejscowosc'] = $czechlogisticOrder->getClPickupPointCity();
                $fields['kodpocztowy'] = $czechlogisticOrder->getClPickupPointPostcode();
                if ($isNaPostuOrBalik) {
                    $fields['kodpocztowy'] = $pickupPointId;
                }
            }
        }

        if ($order->getPayment()->getMethod() === 'cashondelivery') {
            $fields['pobranie'] = round((float) $order->getGrandTotal(), 2);
        }

        $postvars = '';
        foreach($fields as $key=>$value) {
            $postvars .= $key . "=" . $value . "&";
        }
        $url = $this->czechApiUrl . '/przesylki/dodaj';
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "CL-API-KEY: $apiKey",
            "CL-API-TOKEN: $apiSecret"
        ]);
        curl_setopt($ch,CURLOPT_URL,$url);
        curl_setopt($ch,CURLOPT_POST, 1);                //0 for a get request
        curl_setopt($ch,CURLOPT_POSTFIELDS,$postvars);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch,CURLOPT_CONNECTTIMEOUT ,3);
        curl_setopt($ch,CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        $response = curl_exec($ch);
        return json_decode($response);
    }

    private function parsePointId($pointId)
    {
        $ch = curl_init();
        $endpoint = 'https://iai-bridge.paxy.pl/api/v1/paxyWidget/parsePointId';
        curl_setopt($ch, CURLOPT_URL, $endpoint);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "token: 0915bec4fd0f2c7ab3ea8e50a7c355a9b4692a84f0ff638d4af6e79cce8a"
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $data_string = json_encode(array("id"=>$pointId));
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        $apiResponse = curl_exec($ch);
        curl_close($ch);
        if ($apiResponse) {
            return json_decode($apiResponse,true);
        }

        return [];
    }
}
