<?php


namespace Vendor\CzechlogisticIntegration\Block\Adminhtml\Order\View\Tab;


use Magento\Framework\ObjectManagerInterface;
use Vendor\CzechlogisticIntegration\Model\CzechlogisticOrder;
use Vendor\CzechlogisticIntegration\Model\ResourceModel\CzechlogisticOrder\Collection;

class CzechlogisticTransportTab extends \Magento\Backend\Block\Template implements \Magento\Backend\Block\Widget\Tab\TabInterface
{
    /**
     * Template
     *
     * @var string
     */
    protected $_template = 'order/view/tab/czechlogistic_tab.phtml';

    /**
     * Core registry
     *
     * @var \Magento\Framework\Registry
     */
    protected $coreRegistry = null;
    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    /**
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        ObjectManagerInterface $objectManager,
        array $data = []
    ) {
        $this->coreRegistry = $registry;
        parent::__construct($context, $data);
        $this->objectManager = $objectManager;
    }

    /**
     * Retrieve order model instance
     *
     * @return \Magento\Sales\Model\Order
     */
    public function getOrder()
    {
        return $this->coreRegistry->registry('current_order');
    }

    public function getClOrder()
    {
        $order = $this->coreRegistry->registry('current_order');

        $czechlogisticOrder = $this->objectManager->create(Collection::class)->addFieldToFilter('order_id', $order->getId());
        /** @var CzechlogisticOrder $czechlogisticOrder */
        $czechlogisticOrder = $czechlogisticOrder->getFirstItem();
        return $czechlogisticOrder;
    }

    /**
     * {@inheritdoc}
     */
    public function getTabLabel()
    {
        return __('Czechlogistic transport');
    }

    /**
     * {@inheritdoc}
     */
    public function getTabTitle()
    {
        return __('Czechlogistic transport');
    }

    /**
     * {@inheritdoc}
     */
    public function canShowTab()
    {
        // For me, I wanted this tab to always show
        // You can play around with the ACL settings
        // to selectively show later if you want
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function isHidden()
    {
        // For me, I wanted this tab to always show
        // You can play around with conditions to
        // show the tab later
        return false;
    }

    /**
     * Get Tab Class
     *
     * @return string
     */
    public function getTabClass()
    {
        // I wanted mine to load via AJAX when it's selected
        // That's what this does
        return 'ajax only';
    }

    /**
     * Get Class
     *
     * @return string
     */
    public function getClass()
    {
        return $this->getTabClass();
    }

    /**
     * Get Tab Url
     *
     * @return string
     */
    public function getTabUrl()
    {
        // customtab is a adminhtml router we're about to define
        // the full route can really be whatever you want
        return $this->getUrl('customtab/*/customtab', ['_current' => true]);
    }
}
